/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.proto._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.proto._case.IpProto;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpProtoBuilder
implements Builder<IpProto> {
    private Short _protocolNumber;
    Map<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>> augmentation = Collections.emptyMap();

    public IpProtoBuilder() {
    }

    public IpProtoBuilder(IpProto base) {
        AugmentationHolder casted;
        this._protocolNumber = base.getProtocolNumber();
        if (base instanceof IpProtoImpl) {
            IpProtoImpl impl = (IpProtoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>>(casted.augmentations());
        }
    }

    public Short getProtocolNumber() {
        return this._protocolNumber;
    }

    public <E extends Augmentation<IpProto>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkProtocolNumberRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public IpProtoBuilder setProtocolNumber(Short value) {
        if (value != null) {
            IpProtoBuilder.checkProtocolNumberRange(value);
        }
        this._protocolNumber = value;
        return this;
    }

    public IpProtoBuilder addAugmentation(Class<? extends Augmentation<IpProto>> augmentationType, Augmentation<IpProto> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpProtoBuilder removeAugmentation(Class<? extends Augmentation<IpProto>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IpProto build() {
        return new IpProtoImpl(this);
    }

    private static final class IpProtoImpl
    implements IpProto {
        private final Short _protocolNumber;
        private Map<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IpProto> getImplementedInterface() {
            return IpProto.class;
        }

        private IpProtoImpl(IpProtoBuilder base) {
            this._protocolNumber = base.getProtocolNumber();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getProtocolNumber() {
            return this._protocolNumber;
        }

        public <E extends Augmentation<IpProto>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._protocolNumber);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IpProto.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IpProto other = (IpProto)obj;
            if (!Objects.equals(this._protocolNumber, other.getProtocolNumber())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpProtoImpl otherImpl = (IpProtoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IpProto>>, Augmentation<IpProto>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IpProto [");
            boolean first = true;
            if (this._protocolNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocolNumber=");
                builder.append(this._protocolNumber);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

