/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.dst._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.dst._case.Ipv4Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv4DstBuilder
implements Builder<Ipv4Dst> {
    private Ipv4Address _ipv4Address;
    private byte[] _mask;
    Map<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>> augmentation = Collections.emptyMap();

    public Ipv4DstBuilder() {
    }

    public Ipv4DstBuilder(Ipv4Dst base) {
        AugmentationHolder casted;
        this._ipv4Address = base.getIpv4Address();
        this._mask = base.getMask();
        if (base instanceof Ipv4DstImpl) {
            Ipv4DstImpl impl = (Ipv4DstImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>>(casted.augmentations());
        }
    }

    public Ipv4Address getIpv4Address() {
        return this._ipv4Address;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<Ipv4Dst>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv4DstBuilder setIpv4Address(Ipv4Address value) {
        this._ipv4Address = value;
        return this;
    }

    public Ipv4DstBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public Ipv4DstBuilder addAugmentation(Class<? extends Augmentation<Ipv4Dst>> augmentationType, Augmentation<Ipv4Dst> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv4DstBuilder removeAugmentation(Class<? extends Augmentation<Ipv4Dst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv4Dst build() {
        return new Ipv4DstImpl(this);
    }

    private static final class Ipv4DstImpl
    implements Ipv4Dst {
        private final Ipv4Address _ipv4Address;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv4Dst> getImplementedInterface() {
            return Ipv4Dst.class;
        }

        private Ipv4DstImpl(Ipv4DstBuilder base) {
            this._ipv4Address = base.getIpv4Address();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getIpv4Address() {
            return this._ipv4Address;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<Ipv4Dst>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv4Address);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv4Dst.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv4Dst other = (Ipv4Dst)obj;
            if (!Objects.equals(this._ipv4Address, other.getIpv4Address())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv4DstImpl otherImpl = (Ipv4DstImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv4Dst>>, Augmentation<Ipv4Dst>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv4Dst [");
            boolean first = true;
            if (this._ipv4Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv4Address=");
                builder.append(this._ipv4Address);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

