/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.src._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.src._case.Ipv4Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv4SrcBuilder
implements Builder<Ipv4Src> {
    private Ipv4Address _ipv4Address;
    private byte[] _mask;
    Map<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>> augmentation = Collections.emptyMap();

    public Ipv4SrcBuilder() {
    }

    public Ipv4SrcBuilder(Ipv4Src base) {
        AugmentationHolder casted;
        this._ipv4Address = base.getIpv4Address();
        this._mask = base.getMask();
        if (base instanceof Ipv4SrcImpl) {
            Ipv4SrcImpl impl = (Ipv4SrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>>(casted.augmentations());
        }
    }

    public Ipv4Address getIpv4Address() {
        return this._ipv4Address;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<Ipv4Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv4SrcBuilder setIpv4Address(Ipv4Address value) {
        this._ipv4Address = value;
        return this;
    }

    public Ipv4SrcBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public Ipv4SrcBuilder addAugmentation(Class<? extends Augmentation<Ipv4Src>> augmentationType, Augmentation<Ipv4Src> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv4SrcBuilder removeAugmentation(Class<? extends Augmentation<Ipv4Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv4Src build() {
        return new Ipv4SrcImpl(this);
    }

    private static final class Ipv4SrcImpl
    implements Ipv4Src {
        private final Ipv4Address _ipv4Address;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv4Src> getImplementedInterface() {
            return Ipv4Src.class;
        }

        private Ipv4SrcImpl(Ipv4SrcBuilder base) {
            this._ipv4Address = base.getIpv4Address();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getIpv4Address() {
            return this._ipv4Address;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<Ipv4Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv4Address);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv4Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv4Src other = (Ipv4Src)obj;
            if (!Objects.equals(this._ipv4Address, other.getIpv4Address())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv4SrcImpl otherImpl = (Ipv4SrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv4Src>>, Augmentation<Ipv4Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv4Src [");
            boolean first = true;
            if (this._ipv4Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv4Address=");
                builder.append(this._ipv4Address);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

