/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.dst._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.dst._case.Ipv6Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6DstBuilder
implements Builder<Ipv6Dst> {
    private Ipv6Address _ipv6Address;
    private byte[] _mask;
    Map<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>> augmentation = Collections.emptyMap();

    public Ipv6DstBuilder() {
    }

    public Ipv6DstBuilder(Ipv6Dst base) {
        AugmentationHolder casted;
        this._ipv6Address = base.getIpv6Address();
        this._mask = base.getMask();
        if (base instanceof Ipv6DstImpl) {
            Ipv6DstImpl impl = (Ipv6DstImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>>(casted.augmentations());
        }
    }

    public Ipv6Address getIpv6Address() {
        return this._ipv6Address;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<Ipv6Dst>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6DstBuilder setIpv6Address(Ipv6Address value) {
        this._ipv6Address = value;
        return this;
    }

    public Ipv6DstBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public Ipv6DstBuilder addAugmentation(Class<? extends Augmentation<Ipv6Dst>> augmentationType, Augmentation<Ipv6Dst> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6DstBuilder removeAugmentation(Class<? extends Augmentation<Ipv6Dst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6Dst build() {
        return new Ipv6DstImpl(this);
    }

    private static final class Ipv6DstImpl
    implements Ipv6Dst {
        private final Ipv6Address _ipv6Address;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv6Dst> getImplementedInterface() {
            return Ipv6Dst.class;
        }

        private Ipv6DstImpl(Ipv6DstBuilder base) {
            this._ipv6Address = base.getIpv6Address();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6Address getIpv6Address() {
            return this._ipv6Address;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<Ipv6Dst>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv6Address);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6Dst.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6Dst other = (Ipv6Dst)obj;
            if (!Objects.equals(this._ipv6Address, other.getIpv6Address())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6DstImpl otherImpl = (Ipv6DstImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6Dst>>, Augmentation<Ipv6Dst>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv6Dst [");
            boolean first = true;
            if (this._ipv6Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv6Address=");
                builder.append(this._ipv6Address);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

