/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.src._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.src._case.Ipv6Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6SrcBuilder
implements Builder<Ipv6Src> {
    private Ipv6Address _ipv6Address;
    private byte[] _mask;
    Map<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>> augmentation = Collections.emptyMap();

    public Ipv6SrcBuilder() {
    }

    public Ipv6SrcBuilder(Ipv6Src base) {
        AugmentationHolder casted;
        this._ipv6Address = base.getIpv6Address();
        this._mask = base.getMask();
        if (base instanceof Ipv6SrcImpl) {
            Ipv6SrcImpl impl = (Ipv6SrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>>(casted.augmentations());
        }
    }

    public Ipv6Address getIpv6Address() {
        return this._ipv6Address;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<Ipv6Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6SrcBuilder setIpv6Address(Ipv6Address value) {
        this._ipv6Address = value;
        return this;
    }

    public Ipv6SrcBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public Ipv6SrcBuilder addAugmentation(Class<? extends Augmentation<Ipv6Src>> augmentationType, Augmentation<Ipv6Src> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6SrcBuilder removeAugmentation(Class<? extends Augmentation<Ipv6Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6Src build() {
        return new Ipv6SrcImpl(this);
    }

    private static final class Ipv6SrcImpl
    implements Ipv6Src {
        private final Ipv6Address _ipv6Address;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv6Src> getImplementedInterface() {
            return Ipv6Src.class;
        }

        private Ipv6SrcImpl(Ipv6SrcBuilder base) {
            this._ipv6Address = base.getIpv6Address();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6Address getIpv6Address() {
            return this._ipv6Address;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<Ipv6Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv6Address);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6Src other = (Ipv6Src)obj;
            if (!Objects.equals(this._ipv6Address, other.getIpv6Address())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6SrcImpl otherImpl = (Ipv6SrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6Src>>, Augmentation<Ipv6Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv6Src [");
            boolean first = true;
            if (this._ipv6Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv6Address=");
                builder.append(this._ipv6Address);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

