/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.metadata._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.metadata._case.Metadata;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetadataBuilder
implements Builder<Metadata> {
    private byte[] _mask;
    private byte[] _metadata;
    Map<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> augmentation = Collections.emptyMap();

    public MetadataBuilder() {
    }

    public MetadataBuilder(Metadata base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._metadata = base.getMetadata();
        if (base instanceof MetadataImpl) {
            MetadataImpl impl = (MetadataImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>(casted.augmentations());
        }
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public byte[] getMetadata() {
        return this._metadata == null ? null : (byte[])this._metadata.clone();
    }

    public <E extends Augmentation<Metadata>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MetadataBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public MetadataBuilder setMetadata(byte[] value) {
        this._metadata = value;
        return this;
    }

    public MetadataBuilder addAugmentation(Class<? extends Augmentation<Metadata>> augmentationType, Augmentation<Metadata> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MetadataBuilder removeAugmentation(Class<? extends Augmentation<Metadata>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Metadata build() {
        return new MetadataImpl(this);
    }

    private static final class MetadataImpl
    implements Metadata {
        private final byte[] _mask;
        private final byte[] _metadata;
        private Map<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Metadata> getImplementedInterface() {
            return Metadata.class;
        }

        private MetadataImpl(MetadataBuilder base) {
            this._mask = base.getMask();
            this._metadata = base.getMetadata();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>(base.augmentation);
                }
            }
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        @Override
        public byte[] getMetadata() {
            return this._metadata == null ? null : (byte[])this._metadata.clone();
        }

        public <E extends Augmentation<Metadata>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._mask);
            result = 31 * result + Arrays.hashCode(this._metadata);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Metadata.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Metadata other = (Metadata)obj;
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Arrays.equals(this._metadata, other.getMetadata())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetadataImpl otherImpl = (MetadataImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Metadata [");
            boolean first = true;
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (this._metadata != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metadata=");
                builder.append(Arrays.toString(this._metadata));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

