/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.mpls.label._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.mpls.label._case.MplsLabel;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MplsLabelBuilder
implements Builder<MplsLabel> {
    private Long _mplsLabel;
    Map<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>> augmentation = Collections.emptyMap();

    public MplsLabelBuilder() {
    }

    public MplsLabelBuilder(MplsLabel base) {
        AugmentationHolder casted;
        this._mplsLabel = base.getMplsLabel();
        if (base instanceof MplsLabelImpl) {
            MplsLabelImpl impl = (MplsLabelImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>>(casted.augmentations());
        }
    }

    public Long getMplsLabel() {
        return this._mplsLabel;
    }

    public <E extends Augmentation<MplsLabel>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMplsLabelRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MplsLabelBuilder setMplsLabel(Long value) {
        if (value != null) {
            MplsLabelBuilder.checkMplsLabelRange(value);
        }
        this._mplsLabel = value;
        return this;
    }

    public MplsLabelBuilder addAugmentation(Class<? extends Augmentation<MplsLabel>> augmentationType, Augmentation<MplsLabel> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MplsLabelBuilder removeAugmentation(Class<? extends Augmentation<MplsLabel>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MplsLabel build() {
        return new MplsLabelImpl(this);
    }

    private static final class MplsLabelImpl
    implements MplsLabel {
        private final Long _mplsLabel;
        private Map<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MplsLabel> getImplementedInterface() {
            return MplsLabel.class;
        }

        private MplsLabelImpl(MplsLabelBuilder base) {
            this._mplsLabel = base.getMplsLabel();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getMplsLabel() {
            return this._mplsLabel;
        }

        public <E extends Augmentation<MplsLabel>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mplsLabel);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MplsLabel.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MplsLabel other = (MplsLabel)obj;
            if (!Objects.equals(this._mplsLabel, other.getMplsLabel())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MplsLabelImpl otherImpl = (MplsLabelImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MplsLabel>>, Augmentation<MplsLabel>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MplsLabel [");
            boolean first = true;
            if (this._mplsLabel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mplsLabel=");
                builder.append(this._mplsLabel);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

