/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.pbb.isid._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.pbb.isid._case.PbbIsid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PbbIsidBuilder
implements Builder<PbbIsid> {
    private Long _isid;
    private byte[] _mask;
    Map<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>> augmentation = Collections.emptyMap();

    public PbbIsidBuilder() {
    }

    public PbbIsidBuilder(PbbIsid base) {
        AugmentationHolder casted;
        this._isid = base.getIsid();
        this._mask = base.getMask();
        if (base instanceof PbbIsidImpl) {
            PbbIsidImpl impl = (PbbIsidImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>>(casted.augmentations());
        }
    }

    public Long getIsid() {
        return this._isid;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<PbbIsid>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIsidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PbbIsidBuilder setIsid(Long value) {
        if (value != null) {
            PbbIsidBuilder.checkIsidRange(value);
        }
        this._isid = value;
        return this;
    }

    public PbbIsidBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public PbbIsidBuilder addAugmentation(Class<? extends Augmentation<PbbIsid>> augmentationType, Augmentation<PbbIsid> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PbbIsidBuilder removeAugmentation(Class<? extends Augmentation<PbbIsid>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PbbIsid build() {
        return new PbbIsidImpl(this);
    }

    private static final class PbbIsidImpl
    implements PbbIsid {
        private final Long _isid;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PbbIsid> getImplementedInterface() {
            return PbbIsid.class;
        }

        private PbbIsidImpl(PbbIsidBuilder base) {
            this._isid = base.getIsid();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getIsid() {
            return this._isid;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<PbbIsid>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._isid);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PbbIsid.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PbbIsid other = (PbbIsid)obj;
            if (!Objects.equals(this._isid, other.getIsid())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PbbIsidImpl otherImpl = (PbbIsidImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PbbIsid>>, Augmentation<PbbIsid>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PbbIsid [");
            boolean first = true;
            if (this._isid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_isid=");
                builder.append(this._isid);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

