/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.tunnel.id._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.tunnel.id._case.TunnelId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TunnelIdBuilder
implements Builder<TunnelId> {
    private byte[] _mask;
    private byte[] _tunnelId;
    Map<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>> augmentation = Collections.emptyMap();

    public TunnelIdBuilder() {
    }

    public TunnelIdBuilder(TunnelId base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._tunnelId = base.getTunnelId();
        if (base instanceof TunnelIdImpl) {
            TunnelIdImpl impl = (TunnelIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>>(casted.augmentations());
        }
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public byte[] getTunnelId() {
        return this._tunnelId == null ? null : (byte[])this._tunnelId.clone();
    }

    public <E extends Augmentation<TunnelId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TunnelIdBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public TunnelIdBuilder setTunnelId(byte[] value) {
        this._tunnelId = value;
        return this;
    }

    public TunnelIdBuilder addAugmentation(Class<? extends Augmentation<TunnelId>> augmentationType, Augmentation<TunnelId> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TunnelIdBuilder removeAugmentation(Class<? extends Augmentation<TunnelId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TunnelId build() {
        return new TunnelIdImpl(this);
    }

    private static final class TunnelIdImpl
    implements TunnelId {
        private final byte[] _mask;
        private final byte[] _tunnelId;
        private Map<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TunnelId> getImplementedInterface() {
            return TunnelId.class;
        }

        private TunnelIdImpl(TunnelIdBuilder base) {
            this._mask = base.getMask();
            this._tunnelId = base.getTunnelId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>>(base.augmentation);
                }
            }
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        @Override
        public byte[] getTunnelId() {
            return this._tunnelId == null ? null : (byte[])this._tunnelId.clone();
        }

        public <E extends Augmentation<TunnelId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._mask);
            result = 31 * result + Arrays.hashCode(this._tunnelId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TunnelId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TunnelId other = (TunnelId)obj;
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Arrays.equals(this._tunnelId, other.getTunnelId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TunnelIdImpl otherImpl = (TunnelIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TunnelId>>, Augmentation<TunnelId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TunnelId [");
            boolean first = true;
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (this._tunnelId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tunnelId=");
                builder.append(Arrays.toString(this._tunnelId));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

