/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.pcp._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.pcp._case.VlanPcp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VlanPcpBuilder
implements Builder<VlanPcp> {
    private Short _vlanPcp;
    Map<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>> augmentation = Collections.emptyMap();

    public VlanPcpBuilder() {
    }

    public VlanPcpBuilder(VlanPcp base) {
        AugmentationHolder casted;
        this._vlanPcp = base.getVlanPcp();
        if (base instanceof VlanPcpImpl) {
            VlanPcpImpl impl = (VlanPcpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>>(casted.augmentations());
        }
    }

    public Short getVlanPcp() {
        return this._vlanPcp;
    }

    public <E extends Augmentation<VlanPcp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkVlanPcpRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public VlanPcpBuilder setVlanPcp(Short value) {
        if (value != null) {
            VlanPcpBuilder.checkVlanPcpRange(value);
        }
        this._vlanPcp = value;
        return this;
    }

    public VlanPcpBuilder addAugmentation(Class<? extends Augmentation<VlanPcp>> augmentationType, Augmentation<VlanPcp> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VlanPcpBuilder removeAugmentation(Class<? extends Augmentation<VlanPcp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VlanPcp build() {
        return new VlanPcpImpl(this);
    }

    private static final class VlanPcpImpl
    implements VlanPcp {
        private final Short _vlanPcp;
        private Map<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VlanPcp> getImplementedInterface() {
            return VlanPcp.class;
        }

        private VlanPcpImpl(VlanPcpBuilder base) {
            this._vlanPcp = base.getVlanPcp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getVlanPcp() {
            return this._vlanPcp;
        }

        public <E extends Augmentation<VlanPcp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._vlanPcp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VlanPcp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VlanPcp other = (VlanPcp)obj;
            if (!Objects.equals(this._vlanPcp, other.getVlanPcp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VlanPcpImpl otherImpl = (VlanPcpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VlanPcp>>, Augmentation<VlanPcp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VlanPcp [");
            boolean first = true;
            if (this._vlanPcp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vlanPcp=");
                builder.append(this._vlanPcp);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

