/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.vid._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.vid._case.VlanVid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VlanVidBuilder
implements Builder<VlanVid> {
    private byte[] _mask;
    private Integer _vlanVid;
    private Boolean _cfiBit;
    Map<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>> augmentation = Collections.emptyMap();

    public VlanVidBuilder() {
    }

    public VlanVidBuilder(VlanVid base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._vlanVid = base.getVlanVid();
        this._cfiBit = base.isCfiBit();
        if (base instanceof VlanVidImpl) {
            VlanVidImpl impl = (VlanVidImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>>(casted.augmentations());
        }
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public Integer getVlanVid() {
        return this._vlanVid;
    }

    public Boolean isCfiBit() {
        return this._cfiBit;
    }

    public <E extends Augmentation<VlanVid>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VlanVidBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    private static void checkVlanVidRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public VlanVidBuilder setVlanVid(Integer value) {
        if (value != null) {
            VlanVidBuilder.checkVlanVidRange(value);
        }
        this._vlanVid = value;
        return this;
    }

    public VlanVidBuilder setCfiBit(Boolean value) {
        this._cfiBit = value;
        return this;
    }

    public VlanVidBuilder addAugmentation(Class<? extends Augmentation<VlanVid>> augmentationType, Augmentation<VlanVid> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VlanVidBuilder removeAugmentation(Class<? extends Augmentation<VlanVid>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VlanVid build() {
        return new VlanVidImpl(this);
    }

    private static final class VlanVidImpl
    implements VlanVid {
        private final byte[] _mask;
        private final Integer _vlanVid;
        private final Boolean _cfiBit;
        private Map<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VlanVid> getImplementedInterface() {
            return VlanVid.class;
        }

        private VlanVidImpl(VlanVidBuilder base) {
            this._mask = base.getMask();
            this._vlanVid = base.getVlanVid();
            this._cfiBit = base.isCfiBit();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>>(base.augmentation);
                }
            }
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        @Override
        public Integer getVlanVid() {
            return this._vlanVid;
        }

        @Override
        public Boolean isCfiBit() {
            return this._cfiBit;
        }

        public <E extends Augmentation<VlanVid>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._vlanVid);
            result = 31 * result + Objects.hashCode(this._cfiBit);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VlanVid.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VlanVid other = (VlanVid)obj;
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._vlanVid, other.getVlanVid())) {
                return false;
            }
            if (!Objects.equals(this._cfiBit, other.isCfiBit())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VlanVidImpl otherImpl = (VlanVidImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VlanVid>>, Augmentation<VlanVid>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VlanVid [");
            boolean first = true;
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (this._vlanVid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vlanVid=");
                builder.append(this._vlanVid);
            }
            if (this._cfiBit != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cfiBit=");
                builder.append(this._cfiBit);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

