/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MatchTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntriesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchBuilder
implements Builder<Match> {
    private List<MatchEntry> _matchEntry;
    private Class<? extends MatchTypeBase> _type;
    Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();

    public MatchBuilder() {
    }

    public MatchBuilder(MatchEntriesGrouping arg) {
        this._matchEntry = arg.getMatchEntry();
    }

    public MatchBuilder(Match base) {
        AugmentationHolder casted;
        this._matchEntry = base.getMatchEntry();
        this._type = base.getType();
        if (base instanceof MatchImpl) {
            MatchImpl impl = (MatchImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MatchEntriesGrouping) {
            this._matchEntry = ((MatchEntriesGrouping)arg).getMatchEntry();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntriesGrouping] \nbut was: " + arg);
        }
    }

    public List<MatchEntry> getMatchEntry() {
        return this._matchEntry;
    }

    public Class<? extends MatchTypeBase> getType() {
        return this._type;
    }

    public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchBuilder setMatchEntry(List<MatchEntry> value) {
        this._matchEntry = value;
        return this;
    }

    public MatchBuilder setType(Class<? extends MatchTypeBase> value) {
        this._type = value;
        return this;
    }

    public MatchBuilder addAugmentation(Class<? extends Augmentation<Match>> augmentationType, Augmentation<Match> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchBuilder removeAugmentation(Class<? extends Augmentation<Match>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
    implements Match {
        private final List<MatchEntry> _matchEntry;
        private final Class<? extends MatchTypeBase> _type;
        private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Match> getImplementedInterface() {
            return Match.class;
        }

        private MatchImpl(MatchBuilder base) {
            this._matchEntry = base.getMatchEntry();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(base.augmentation);
                }
            }
        }

        @Override
        public List<MatchEntry> getMatchEntry() {
            return this._matchEntry;
        }

        @Override
        public Class<? extends MatchTypeBase> getType() {
            return this._type;
        }

        public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._matchEntry);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Match.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Match other = (Match)obj;
            if (!Objects.equals(this._matchEntry, other.getMatchEntry())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchImpl otherImpl = (MatchImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Match [");
            boolean first = true;
            if (this._matchEntry != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchEntry=");
                builder.append(this._matchEntry);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

