/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchV10Builder
implements Builder<MatchV10> {
    private MacAddress _dlDst;
    private MacAddress _dlSrc;
    private Integer _dlType;
    private Integer _dlVlan;
    private Short _dlVlanPcp;
    private Integer _inPort;
    private Ipv4Address _nwDst;
    private Short _nwDstMask;
    private Short _nwProto;
    private Ipv4Address _nwSrc;
    private Short _nwSrcMask;
    private Short _nwTos;
    private Integer _tpDst;
    private Integer _tpSrc;
    private FlowWildcardsV10 _wildcards;
    Map<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> augmentation = Collections.emptyMap();

    public MatchV10Builder() {
    }

    public MatchV10Builder(MatchV10 base) {
        AugmentationHolder casted;
        this._dlDst = base.getDlDst();
        this._dlSrc = base.getDlSrc();
        this._dlType = base.getDlType();
        this._dlVlan = base.getDlVlan();
        this._dlVlanPcp = base.getDlVlanPcp();
        this._inPort = base.getInPort();
        this._nwDst = base.getNwDst();
        this._nwDstMask = base.getNwDstMask();
        this._nwProto = base.getNwProto();
        this._nwSrc = base.getNwSrc();
        this._nwSrcMask = base.getNwSrcMask();
        this._nwTos = base.getNwTos();
        this._tpDst = base.getTpDst();
        this._tpSrc = base.getTpSrc();
        this._wildcards = base.getWildcards();
        if (base instanceof MatchV10Impl) {
            MatchV10Impl impl = (MatchV10Impl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>(casted.augmentations());
        }
    }

    public MacAddress getDlDst() {
        return this._dlDst;
    }

    public MacAddress getDlSrc() {
        return this._dlSrc;
    }

    public Integer getDlType() {
        return this._dlType;
    }

    public Integer getDlVlan() {
        return this._dlVlan;
    }

    public Short getDlVlanPcp() {
        return this._dlVlanPcp;
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Ipv4Address getNwDst() {
        return this._nwDst;
    }

    public Short getNwDstMask() {
        return this._nwDstMask;
    }

    public Short getNwProto() {
        return this._nwProto;
    }

    public Ipv4Address getNwSrc() {
        return this._nwSrc;
    }

    public Short getNwSrcMask() {
        return this._nwSrcMask;
    }

    public Short getNwTos() {
        return this._nwTos;
    }

    public Integer getTpDst() {
        return this._tpDst;
    }

    public Integer getTpSrc() {
        return this._tpSrc;
    }

    public FlowWildcardsV10 getWildcards() {
        return this._wildcards;
    }

    public <E extends Augmentation<MatchV10>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchV10Builder setDlDst(MacAddress value) {
        this._dlDst = value;
        return this;
    }

    public MatchV10Builder setDlSrc(MacAddress value) {
        this._dlSrc = value;
        return this;
    }

    private static void checkDlTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public MatchV10Builder setDlType(Integer value) {
        if (value != null) {
            MatchV10Builder.checkDlTypeRange(value);
        }
        this._dlType = value;
        return this;
    }

    private static void checkDlVlanRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public MatchV10Builder setDlVlan(Integer value) {
        if (value != null) {
            MatchV10Builder.checkDlVlanRange(value);
        }
        this._dlVlan = value;
        return this;
    }

    private static void checkDlVlanPcpRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MatchV10Builder setDlVlanPcp(Short value) {
        if (value != null) {
            MatchV10Builder.checkDlVlanPcpRange(value);
        }
        this._dlVlanPcp = value;
        return this;
    }

    private static void checkInPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public MatchV10Builder setInPort(Integer value) {
        if (value != null) {
            MatchV10Builder.checkInPortRange(value);
        }
        this._inPort = value;
        return this;
    }

    public MatchV10Builder setNwDst(Ipv4Address value) {
        this._nwDst = value;
        return this;
    }

    private static void checkNwDstMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MatchV10Builder setNwDstMask(Short value) {
        if (value != null) {
            MatchV10Builder.checkNwDstMaskRange(value);
        }
        this._nwDstMask = value;
        return this;
    }

    private static void checkNwProtoRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MatchV10Builder setNwProto(Short value) {
        if (value != null) {
            MatchV10Builder.checkNwProtoRange(value);
        }
        this._nwProto = value;
        return this;
    }

    public MatchV10Builder setNwSrc(Ipv4Address value) {
        this._nwSrc = value;
        return this;
    }

    private static void checkNwSrcMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MatchV10Builder setNwSrcMask(Short value) {
        if (value != null) {
            MatchV10Builder.checkNwSrcMaskRange(value);
        }
        this._nwSrcMask = value;
        return this;
    }

    private static void checkNwTosRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MatchV10Builder setNwTos(Short value) {
        if (value != null) {
            MatchV10Builder.checkNwTosRange(value);
        }
        this._nwTos = value;
        return this;
    }

    private static void checkTpDstRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public MatchV10Builder setTpDst(Integer value) {
        if (value != null) {
            MatchV10Builder.checkTpDstRange(value);
        }
        this._tpDst = value;
        return this;
    }

    private static void checkTpSrcRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public MatchV10Builder setTpSrc(Integer value) {
        if (value != null) {
            MatchV10Builder.checkTpSrcRange(value);
        }
        this._tpSrc = value;
        return this;
    }

    public MatchV10Builder setWildcards(FlowWildcardsV10 value) {
        this._wildcards = value;
        return this;
    }

    public MatchV10Builder addAugmentation(Class<? extends Augmentation<MatchV10>> augmentationType, Augmentation<MatchV10> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchV10Builder removeAugmentation(Class<? extends Augmentation<MatchV10>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MatchV10 build() {
        return new MatchV10Impl(this);
    }

    private static final class MatchV10Impl
    implements MatchV10 {
        private final MacAddress _dlDst;
        private final MacAddress _dlSrc;
        private final Integer _dlType;
        private final Integer _dlVlan;
        private final Short _dlVlanPcp;
        private final Integer _inPort;
        private final Ipv4Address _nwDst;
        private final Short _nwDstMask;
        private final Short _nwProto;
        private final Ipv4Address _nwSrc;
        private final Short _nwSrcMask;
        private final Short _nwTos;
        private final Integer _tpDst;
        private final Integer _tpSrc;
        private final FlowWildcardsV10 _wildcards;
        private Map<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MatchV10> getImplementedInterface() {
            return MatchV10.class;
        }

        private MatchV10Impl(MatchV10Builder base) {
            this._dlDst = base.getDlDst();
            this._dlSrc = base.getDlSrc();
            this._dlType = base.getDlType();
            this._dlVlan = base.getDlVlan();
            this._dlVlanPcp = base.getDlVlanPcp();
            this._inPort = base.getInPort();
            this._nwDst = base.getNwDst();
            this._nwDstMask = base.getNwDstMask();
            this._nwProto = base.getNwProto();
            this._nwSrc = base.getNwSrc();
            this._nwSrcMask = base.getNwSrcMask();
            this._nwTos = base.getNwTos();
            this._tpDst = base.getTpDst();
            this._tpSrc = base.getTpSrc();
            this._wildcards = base.getWildcards();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>(base.augmentation);
                }
            }
        }

        @Override
        public MacAddress getDlDst() {
            return this._dlDst;
        }

        @Override
        public MacAddress getDlSrc() {
            return this._dlSrc;
        }

        @Override
        public Integer getDlType() {
            return this._dlType;
        }

        @Override
        public Integer getDlVlan() {
            return this._dlVlan;
        }

        @Override
        public Short getDlVlanPcp() {
            return this._dlVlanPcp;
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Ipv4Address getNwDst() {
            return this._nwDst;
        }

        @Override
        public Short getNwDstMask() {
            return this._nwDstMask;
        }

        @Override
        public Short getNwProto() {
            return this._nwProto;
        }

        @Override
        public Ipv4Address getNwSrc() {
            return this._nwSrc;
        }

        @Override
        public Short getNwSrcMask() {
            return this._nwSrcMask;
        }

        @Override
        public Short getNwTos() {
            return this._nwTos;
        }

        @Override
        public Integer getTpDst() {
            return this._tpDst;
        }

        @Override
        public Integer getTpSrc() {
            return this._tpSrc;
        }

        @Override
        public FlowWildcardsV10 getWildcards() {
            return this._wildcards;
        }

        public <E extends Augmentation<MatchV10>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dlDst);
            result = 31 * result + Objects.hashCode(this._dlSrc);
            result = 31 * result + Objects.hashCode(this._dlType);
            result = 31 * result + Objects.hashCode(this._dlVlan);
            result = 31 * result + Objects.hashCode(this._dlVlanPcp);
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._nwDst);
            result = 31 * result + Objects.hashCode(this._nwDstMask);
            result = 31 * result + Objects.hashCode(this._nwProto);
            result = 31 * result + Objects.hashCode(this._nwSrc);
            result = 31 * result + Objects.hashCode(this._nwSrcMask);
            result = 31 * result + Objects.hashCode(this._nwTos);
            result = 31 * result + Objects.hashCode(this._tpDst);
            result = 31 * result + Objects.hashCode(this._tpSrc);
            result = 31 * result + Objects.hashCode(this._wildcards);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MatchV10.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MatchV10 other = (MatchV10)obj;
            if (!Objects.equals(this._dlDst, other.getDlDst())) {
                return false;
            }
            if (!Objects.equals(this._dlSrc, other.getDlSrc())) {
                return false;
            }
            if (!Objects.equals(this._dlType, other.getDlType())) {
                return false;
            }
            if (!Objects.equals(this._dlVlan, other.getDlVlan())) {
                return false;
            }
            if (!Objects.equals(this._dlVlanPcp, other.getDlVlanPcp())) {
                return false;
            }
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._nwDst, other.getNwDst())) {
                return false;
            }
            if (!Objects.equals(this._nwDstMask, other.getNwDstMask())) {
                return false;
            }
            if (!Objects.equals(this._nwProto, other.getNwProto())) {
                return false;
            }
            if (!Objects.equals(this._nwSrc, other.getNwSrc())) {
                return false;
            }
            if (!Objects.equals(this._nwSrcMask, other.getNwSrcMask())) {
                return false;
            }
            if (!Objects.equals(this._nwTos, other.getNwTos())) {
                return false;
            }
            if (!Objects.equals(this._tpDst, other.getTpDst())) {
                return false;
            }
            if (!Objects.equals(this._tpSrc, other.getTpSrc())) {
                return false;
            }
            if (!Objects.equals(this._wildcards, other.getWildcards())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchV10Impl otherImpl = (MatchV10Impl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MatchV10 [");
            boolean first = true;
            if (this._dlDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dlDst=");
                builder.append(this._dlDst);
            }
            if (this._dlSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dlSrc=");
                builder.append(this._dlSrc);
            }
            if (this._dlType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dlType=");
                builder.append(this._dlType);
            }
            if (this._dlVlan != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dlVlan=");
                builder.append(this._dlVlan);
            }
            if (this._dlVlanPcp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dlVlanPcp=");
                builder.append(this._dlVlanPcp);
            }
            if (this._inPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPort=");
                builder.append(this._inPort);
            }
            if (this._nwDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwDst=");
                builder.append(this._nwDst);
            }
            if (this._nwDstMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwDstMask=");
                builder.append(this._nwDstMask);
            }
            if (this._nwProto != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwProto=");
                builder.append(this._nwProto);
            }
            if (this._nwSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwSrc=");
                builder.append(this._nwSrc);
            }
            if (this._nwSrcMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwSrcMask=");
                builder.append(this._nwSrcMask);
            }
            if (this._nwTos != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwTos=");
                builder.append(this._nwTos);
            }
            if (this._tpDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tpDst=");
                builder.append(this._tpDst);
            }
            if (this._tpSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tpSrc=");
                builder.append(this._tpSrc);
            }
            if (this._wildcards != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_wildcards=");
                builder.append(this._wildcards);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

