/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Error;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ErrorMessageBuilder
implements Builder<ErrorMessage> {
    private Integer _code;
    private String _codeString;
    private byte[] _data;
    private Integer _type;
    private String _typeString;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> augmentation = Collections.emptyMap();

    public ErrorMessageBuilder() {
    }

    public ErrorMessageBuilder(Error arg) {
        this._type = arg.getType();
        this._code = arg.getCode();
        this._typeString = arg.getTypeString();
        this._codeString = arg.getCodeString();
        this._data = arg.getData();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public ErrorMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public ErrorMessageBuilder(ErrorMessage base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._codeString = base.getCodeString();
        this._data = base.getData();
        this._type = base.getType();
        this._typeString = base.getTypeString();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof ErrorMessageImpl) {
            ErrorMessageImpl impl = (ErrorMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Error) {
            this._type = ((Error)arg).getType();
            this._code = ((Error)arg).getCode();
            this._typeString = ((Error)arg).getTypeString();
            this._codeString = ((Error)arg).getCodeString();
            this._data = ((Error)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Error, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getCodeString() {
        return this._codeString;
    }

    public byte[] getData() {
        return this._data == null ? null : (byte[])this._data.clone();
    }

    public Integer getType() {
        return this._type;
    }

    public String getTypeString() {
        return this._typeString;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ErrorMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ErrorMessageBuilder setCode(Integer value) {
        if (value != null) {
            ErrorMessageBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    public ErrorMessageBuilder setCodeString(String value) {
        this._codeString = value;
        return this;
    }

    public ErrorMessageBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    private static void checkTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ErrorMessageBuilder setType(Integer value) {
        if (value != null) {
            ErrorMessageBuilder.checkTypeRange(value);
        }
        this._type = value;
        return this;
    }

    public ErrorMessageBuilder setTypeString(String value) {
        this._typeString = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ErrorMessageBuilder setVersion(Short value) {
        if (value != null) {
            ErrorMessageBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ErrorMessageBuilder setXid(Long value) {
        if (value != null) {
            ErrorMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public ErrorMessageBuilder addAugmentation(Class<? extends Augmentation<ErrorMessage>> augmentationType, Augmentation<ErrorMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ErrorMessageBuilder removeAugmentation(Class<? extends Augmentation<ErrorMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ErrorMessage build() {
        return new ErrorMessageImpl(this);
    }

    private static final class ErrorMessageImpl
    implements ErrorMessage {
        private final Integer _code;
        private final String _codeString;
        private final byte[] _data;
        private final Integer _type;
        private final String _typeString;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ErrorMessage> getImplementedInterface() {
            return ErrorMessage.class;
        }

        private ErrorMessageImpl(ErrorMessageBuilder base) {
            this._code = base.getCode();
            this._codeString = base.getCodeString();
            this._data = base.getData();
            this._type = base.getType();
            this._typeString = base.getTypeString();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getCodeString() {
            return this._codeString;
        }

        @Override
        public byte[] getData() {
            return this._data == null ? null : (byte[])this._data.clone();
        }

        @Override
        public Integer getType() {
            return this._type;
        }

        @Override
        public String getTypeString() {
            return this._typeString;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ErrorMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._codeString);
            result = 31 * result + Arrays.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._typeString);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ErrorMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._codeString, other.getCodeString())) {
                return false;
            }
            if (!Arrays.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._typeString, other.getTypeString())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ErrorMessageImpl otherImpl = (ErrorMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ErrorMessage [");
            boolean first = true;
            if (this._code != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_code=");
                builder.append(this._code);
            }
            if (this._codeString != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_codeString=");
                builder.append(this._codeString);
            }
            if (this._data != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_data=");
                builder.append(Arrays.toString(this._data));
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (this._typeString != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_typeString=");
                builder.append(this._typeString);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

