/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterCore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExperimenterMessageBuilder
implements Builder<ExperimenterMessage> {
    private Long _expType;
    private ExperimenterId _experimenter;
    private ExperimenterDataOfChoice _experimenterDataOfChoice;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> augmentation = Collections.emptyMap();

    public ExperimenterMessageBuilder() {
    }

    public ExperimenterMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public ExperimenterMessageBuilder(ExperimenterCore arg) {
        this._experimenter = arg.getExperimenter();
        this._expType = arg.getExpType();
        this._experimenterDataOfChoice = arg.getExperimenterDataOfChoice();
    }

    public ExperimenterMessageBuilder(ExperimenterMessage base) {
        AugmentationHolder casted;
        this._expType = base.getExpType();
        this._experimenter = base.getExperimenter();
        this._experimenterDataOfChoice = base.getExperimenterDataOfChoice();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof ExperimenterMessageImpl) {
            ExperimenterMessageImpl impl = (ExperimenterMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ExperimenterCore) {
            this._experimenter = ((ExperimenterCore)arg).getExperimenter();
            this._expType = ((ExperimenterCore)arg).getExpType();
            this._experimenterDataOfChoice = ((ExperimenterCore)arg).getExperimenterDataOfChoice();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterCore, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public Long getExpType() {
        return this._expType;
    }

    public ExperimenterId getExperimenter() {
        return this._experimenter;
    }

    public ExperimenterDataOfChoice getExperimenterDataOfChoice() {
        return this._experimenterDataOfChoice;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ExperimenterMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkExpTypeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ExperimenterMessageBuilder setExpType(Long value) {
        if (value != null) {
            ExperimenterMessageBuilder.checkExpTypeRange(value);
        }
        this._expType = value;
        return this;
    }

    public ExperimenterMessageBuilder setExperimenter(ExperimenterId value) {
        this._experimenter = value;
        return this;
    }

    public ExperimenterMessageBuilder setExperimenterDataOfChoice(ExperimenterDataOfChoice value) {
        this._experimenterDataOfChoice = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ExperimenterMessageBuilder setVersion(Short value) {
        if (value != null) {
            ExperimenterMessageBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ExperimenterMessageBuilder setXid(Long value) {
        if (value != null) {
            ExperimenterMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public ExperimenterMessageBuilder addAugmentation(Class<? extends Augmentation<ExperimenterMessage>> augmentationType, Augmentation<ExperimenterMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ExperimenterMessageBuilder removeAugmentation(Class<? extends Augmentation<ExperimenterMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ExperimenterMessage build() {
        return new ExperimenterMessageImpl(this);
    }

    private static final class ExperimenterMessageImpl
    implements ExperimenterMessage {
        private final Long _expType;
        private final ExperimenterId _experimenter;
        private final ExperimenterDataOfChoice _experimenterDataOfChoice;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ExperimenterMessage> getImplementedInterface() {
            return ExperimenterMessage.class;
        }

        private ExperimenterMessageImpl(ExperimenterMessageBuilder base) {
            this._expType = base.getExpType();
            this._experimenter = base.getExperimenter();
            this._experimenterDataOfChoice = base.getExperimenterDataOfChoice();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getExpType() {
            return this._expType;
        }

        @Override
        public ExperimenterId getExperimenter() {
            return this._experimenter;
        }

        @Override
        public ExperimenterDataOfChoice getExperimenterDataOfChoice() {
            return this._experimenterDataOfChoice;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ExperimenterMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._expType);
            result = 31 * result + Objects.hashCode(this._experimenter);
            result = 31 * result + Objects.hashCode(this._experimenterDataOfChoice);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ExperimenterMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ExperimenterMessage other = (ExperimenterMessage)obj;
            if (!Objects.equals(this._expType, other.getExpType())) {
                return false;
            }
            if (!Objects.equals(this._experimenter, other.getExperimenter())) {
                return false;
            }
            if (!Objects.equals(this._experimenterDataOfChoice, other.getExperimenterDataOfChoice())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ExperimenterMessageImpl otherImpl = (ExperimenterMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ExperimenterMessage [");
            boolean first = true;
            if (this._expType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_expType=");
                builder.append(this._expType);
            }
            if (this._experimenter != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenter=");
                builder.append(this._experimenter);
            }
            if (this._experimenterDataOfChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterDataOfChoice=");
                builder.append(this._experimenterDataOfChoice);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

