/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowModInputBuilder
implements Builder<FlowModInput> {
    private List<Action> _action;
    private Long _bufferId;
    private FlowModCommand _command;
    private BigInteger _cookie;
    private BigInteger _cookieMask;
    private FlowModFlags _flags;
    private FlowModFlagsV10 _flagsV10;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private List<Instruction> _instruction;
    private Match _match;
    private MatchV10 _matchV10;
    private Long _outGroup;
    private PortNumber _outPort;
    private Integer _priority;
    private TableId _tableId;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKCOOKIEMASKRANGE_RANGES;

    public FlowModInputBuilder() {
    }

    public FlowModInputBuilder(FlowMod arg) {
        this._cookie = arg.getCookie();
        this._cookieMask = arg.getCookieMask();
        this._tableId = arg.getTableId();
        this._command = arg.getCommand();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._priority = arg.getPriority();
        this._bufferId = arg.getBufferId();
        this._outPort = arg.getOutPort();
        this._outGroup = arg.getOutGroup();
        this._flags = arg.getFlags();
        this._flagsV10 = arg.getFlagsV10();
        this._instruction = arg.getInstruction();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._action = arg.getAction();
        this._match = arg.getMatch();
        this._matchV10 = arg.getMatchV10();
    }

    public FlowModInputBuilder(InstructionsGrouping arg) {
        this._instruction = arg.getInstruction();
    }

    public FlowModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public FlowModInputBuilder(ActionsGrouping arg) {
        this._action = arg.getAction();
    }

    public FlowModInputBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public FlowModInputBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowModInputBuilder(FlowModInput base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._bufferId = base.getBufferId();
        this._command = base.getCommand();
        this._cookie = base.getCookie();
        this._cookieMask = base.getCookieMask();
        this._flags = base.getFlags();
        this._flagsV10 = base.getFlagsV10();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._instruction = base.getInstruction();
        this._match = base.getMatch();
        this._matchV10 = base.getMatchV10();
        this._outGroup = base.getOutGroup();
        this._outPort = base.getOutPort();
        this._priority = base.getPriority();
        this._tableId = base.getTableId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof FlowModInputImpl) {
            FlowModInputImpl impl = (FlowModInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FlowMod) {
            this._cookie = ((FlowMod)arg).getCookie();
            this._cookieMask = ((FlowMod)arg).getCookieMask();
            this._tableId = ((FlowMod)arg).getTableId();
            this._command = ((FlowMod)arg).getCommand();
            this._idleTimeout = ((FlowMod)arg).getIdleTimeout();
            this._hardTimeout = ((FlowMod)arg).getHardTimeout();
            this._priority = ((FlowMod)arg).getPriority();
            this._bufferId = ((FlowMod)arg).getBufferId();
            this._outPort = ((FlowMod)arg).getOutPort();
            this._outGroup = ((FlowMod)arg).getOutGroup();
            this._flags = ((FlowMod)arg).getFlags();
            this._flagsV10 = ((FlowMod)arg).getFlagsV10();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof ActionsGrouping) {
            this._action = ((ActionsGrouping)arg).getAction();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof InstructionsGrouping) {
            this._instruction = ((InstructionsGrouping)arg).getInstruction();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowMod, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public FlowModCommand getCommand() {
        return this._command;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public BigInteger getCookieMask() {
        return this._cookieMask;
    }

    public FlowModFlags getFlags() {
        return this._flags;
    }

    public FlowModFlagsV10 getFlagsV10() {
        return this._flagsV10;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public List<Instruction> getInstruction() {
        return this._instruction;
    }

    public Match getMatch() {
        return this._match;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public Long getOutGroup() {
        return this._outGroup;
    }

    public PortNumber getOutPort() {
        return this._outPort;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<FlowModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowModInputBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowModInputBuilder setBufferId(Long value) {
        if (value != null) {
            FlowModInputBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    public FlowModInputBuilder setCommand(FlowModCommand value) {
        this._command = value;
        return this;
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public FlowModInputBuilder setCookie(BigInteger value) {
        if (value != null) {
            FlowModInputBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    private static void checkCookieMaskRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIEMASKRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIEMASKRANGE_RANGES)));
    }

    public FlowModInputBuilder setCookieMask(BigInteger value) {
        if (value != null) {
            FlowModInputBuilder.checkCookieMaskRange(value);
        }
        this._cookieMask = value;
        return this;
    }

    public FlowModInputBuilder setFlags(FlowModFlags value) {
        this._flags = value;
        return this;
    }

    public FlowModInputBuilder setFlagsV10(FlowModFlagsV10 value) {
        this._flagsV10 = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowModInputBuilder setHardTimeout(Integer value) {
        if (value != null) {
            FlowModInputBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowModInputBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            FlowModInputBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowModInputBuilder setInstruction(List<Instruction> value) {
        this._instruction = value;
        return this;
    }

    public FlowModInputBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowModInputBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    private static void checkOutGroupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowModInputBuilder setOutGroup(Long value) {
        if (value != null) {
            FlowModInputBuilder.checkOutGroupRange(value);
        }
        this._outGroup = value;
        return this;
    }

    public FlowModInputBuilder setOutPort(PortNumber value) {
        this._outPort = value;
        return this;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowModInputBuilder setPriority(Integer value) {
        if (value != null) {
            FlowModInputBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public FlowModInputBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public FlowModInputBuilder setVersion(Short value) {
        if (value != null) {
            FlowModInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowModInputBuilder setXid(Long value) {
        if (value != null) {
            FlowModInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public FlowModInputBuilder addAugmentation(Class<? extends Augmentation<FlowModInput>> augmentationType, Augmentation<FlowModInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowModInputBuilder removeAugmentation(Class<? extends Augmentation<FlowModInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowModInput build() {
        return new FlowModInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIEMASKRANGE_RANGES = a;
    }

    private static final class FlowModInputImpl
    implements FlowModInput {
        private final List<Action> _action;
        private final Long _bufferId;
        private final FlowModCommand _command;
        private final BigInteger _cookie;
        private final BigInteger _cookieMask;
        private final FlowModFlags _flags;
        private final FlowModFlagsV10 _flagsV10;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final List<Instruction> _instruction;
        private final Match _match;
        private final MatchV10 _matchV10;
        private final Long _outGroup;
        private final PortNumber _outPort;
        private final Integer _priority;
        private final TableId _tableId;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowModInput> getImplementedInterface() {
            return FlowModInput.class;
        }

        private FlowModInputImpl(FlowModInputBuilder base) {
            this._action = base.getAction();
            this._bufferId = base.getBufferId();
            this._command = base.getCommand();
            this._cookie = base.getCookie();
            this._cookieMask = base.getCookieMask();
            this._flags = base.getFlags();
            this._flagsV10 = base.getFlagsV10();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._instruction = base.getInstruction();
            this._match = base.getMatch();
            this._matchV10 = base.getMatchV10();
            this._outGroup = base.getOutGroup();
            this._outPort = base.getOutPort();
            this._priority = base.getPriority();
            this._tableId = base.getTableId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public FlowModCommand getCommand() {
            return this._command;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public BigInteger getCookieMask() {
            return this._cookieMask;
        }

        @Override
        public FlowModFlags getFlags() {
            return this._flags;
        }

        @Override
        public FlowModFlagsV10 getFlagsV10() {
            return this._flagsV10;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public List<Instruction> getInstruction() {
            return this._instruction;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public Long getOutGroup() {
            return this._outGroup;
        }

        @Override
        public PortNumber getOutPort() {
            return this._outPort;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<FlowModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._bufferId);
            result = 31 * result + Objects.hashCode((Object)this._command);
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._cookieMask);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._flagsV10);
            result = 31 * result + Objects.hashCode(this._hardTimeout);
            result = 31 * result + Objects.hashCode(this._idleTimeout);
            result = 31 * result + Objects.hashCode(this._instruction);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._matchV10);
            result = 31 * result + Objects.hashCode(this._outGroup);
            result = 31 * result + Objects.hashCode(this._outPort);
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode(this._tableId);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModInput other = (FlowModInput)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._bufferId, other.getBufferId())) {
                return false;
            }
            if (!Objects.equals((Object)this._command, (Object)other.getCommand())) {
                return false;
            }
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._cookieMask, other.getCookieMask())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._flagsV10, other.getFlagsV10())) {
                return false;
            }
            if (!Objects.equals(this._hardTimeout, other.getHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._idleTimeout, other.getIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._instruction, other.getInstruction())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._matchV10, other.getMatchV10())) {
                return false;
            }
            if (!Objects.equals(this._outGroup, other.getOutGroup())) {
                return false;
            }
            if (!Objects.equals(this._outPort, other.getOutPort())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowModInputImpl otherImpl = (FlowModInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FlowModInput [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._bufferId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bufferId=");
                builder.append(this._bufferId);
            }
            if (this._command != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_command=");
                builder.append((Object)this._command);
            }
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._cookieMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookieMask=");
                builder.append(this._cookieMask);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._flagsV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flagsV10=");
                builder.append(this._flagsV10);
            }
            if (this._hardTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
            }
            if (this._idleTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
            }
            if (this._instruction != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instruction=");
                builder.append(this._instruction);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._matchV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchV10=");
                builder.append(this._matchV10);
            }
            if (this._outGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outGroup=");
                builder.append(this._outGroup);
            }
            if (this._outPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outPort=");
                builder.append(this._outPort);
            }
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

