/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowRemovedMessageBuilder
implements Builder<FlowRemovedMessage> {
    private BigInteger _byteCount;
    private BigInteger _cookie;
    private Long _durationNsec;
    private Long _durationSec;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Match _match;
    private MatchV10 _matchV10;
    private BigInteger _packetCount;
    private Integer _priority;
    private FlowRemovedReason _reason;
    private TableId _tableId;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public FlowRemovedMessageBuilder() {
    }

    public FlowRemovedMessageBuilder(FlowRemoved arg) {
        this._cookie = arg.getCookie();
        this._priority = arg.getPriority();
        this._reason = arg.getReason();
        this._tableId = arg.getTableId();
        this._durationSec = arg.getDurationSec();
        this._durationNsec = arg.getDurationNsec();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._packetCount = arg.getPacketCount();
        this._byteCount = arg.getByteCount();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._match = arg.getMatch();
        this._matchV10 = arg.getMatchV10();
    }

    public FlowRemovedMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public FlowRemovedMessageBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public FlowRemovedMessageBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowRemovedMessageBuilder(FlowRemovedMessage base) {
        AugmentationHolder casted;
        this._byteCount = base.getByteCount();
        this._cookie = base.getCookie();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._match = base.getMatch();
        this._matchV10 = base.getMatchV10();
        this._packetCount = base.getPacketCount();
        this._priority = base.getPriority();
        this._reason = base.getReason();
        this._tableId = base.getTableId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof FlowRemovedMessageImpl) {
            FlowRemovedMessageImpl impl = (FlowRemovedMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FlowRemoved) {
            this._cookie = ((FlowRemoved)arg).getCookie();
            this._priority = ((FlowRemoved)arg).getPriority();
            this._reason = ((FlowRemoved)arg).getReason();
            this._tableId = ((FlowRemoved)arg).getTableId();
            this._durationSec = ((FlowRemoved)arg).getDurationSec();
            this._durationNsec = ((FlowRemoved)arg).getDurationNsec();
            this._idleTimeout = ((FlowRemoved)arg).getIdleTimeout();
            this._hardTimeout = ((FlowRemoved)arg).getHardTimeout();
            this._packetCount = ((FlowRemoved)arg).getPacketCount();
            this._byteCount = ((FlowRemoved)arg).getByteCount();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemoved, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping] \nbut was: " + arg);
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Match getMatch() {
        return this._match;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public FlowRemovedReason getReason() {
        return this._reason;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<FlowRemovedMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public FlowRemovedMessageBuilder setByteCount(BigInteger value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public FlowRemovedMessageBuilder setCookie(BigInteger value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowRemovedMessageBuilder setDurationNsec(Long value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowRemovedMessageBuilder setDurationSec(Long value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowRemovedMessageBuilder setHardTimeout(Integer value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowRemovedMessageBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowRemovedMessageBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowRemovedMessageBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public FlowRemovedMessageBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowRemovedMessageBuilder setPriority(Integer value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public FlowRemovedMessageBuilder setReason(FlowRemovedReason value) {
        this._reason = value;
        return this;
    }

    public FlowRemovedMessageBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public FlowRemovedMessageBuilder setVersion(Short value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowRemovedMessageBuilder setXid(Long value) {
        if (value != null) {
            FlowRemovedMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public FlowRemovedMessageBuilder addAugmentation(Class<? extends Augmentation<FlowRemovedMessage>> augmentationType, Augmentation<FlowRemovedMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowRemovedMessageBuilder removeAugmentation(Class<? extends Augmentation<FlowRemovedMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowRemovedMessage build() {
        return new FlowRemovedMessageImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class FlowRemovedMessageImpl
    implements FlowRemovedMessage {
        private final BigInteger _byteCount;
        private final BigInteger _cookie;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Match _match;
        private final MatchV10 _matchV10;
        private final BigInteger _packetCount;
        private final Integer _priority;
        private final FlowRemovedReason _reason;
        private final TableId _tableId;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowRemovedMessage> getImplementedInterface() {
            return FlowRemovedMessage.class;
        }

        private FlowRemovedMessageImpl(FlowRemovedMessageBuilder base) {
            this._byteCount = base.getByteCount();
            this._cookie = base.getCookie();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._match = base.getMatch();
            this._matchV10 = base.getMatchV10();
            this._packetCount = base.getPacketCount();
            this._priority = base.getPriority();
            this._reason = base.getReason();
            this._tableId = base.getTableId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public FlowRemovedReason getReason() {
            return this._reason;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<FlowRemovedMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._hardTimeout);
            result = 31 * result + Objects.hashCode(this._idleTimeout);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._matchV10);
            result = 31 * result + Objects.hashCode(this._packetCount);
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode((Object)this._reason);
            result = 31 * result + Objects.hashCode(this._tableId);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowRemovedMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowRemovedMessage other = (FlowRemovedMessage)obj;
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._hardTimeout, other.getHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._idleTimeout, other.getIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._matchV10, other.getMatchV10())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals((Object)this._reason, (Object)other.getReason())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowRemovedMessageImpl otherImpl = (FlowRemovedMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FlowRemovedMessage [");
            boolean first = true;
            if (this._byteCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteCount=");
                builder.append(this._byteCount);
            }
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._hardTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
            }
            if (this._idleTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._matchV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchV10=");
                builder.append(this._matchV10);
            }
            if (this._packetCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetCount=");
                builder.append(this._packetCount);
            }
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append((Object)this._reason);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

