/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.AsyncBodyGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetAsyncOutputBuilder
implements Builder<GetAsyncOutput> {
    private List<FlowRemovedMask> _flowRemovedMask;
    private List<PacketInMask> _packetInMask;
    private List<PortStatusMask> _portStatusMask;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>> augmentation = Collections.emptyMap();

    public GetAsyncOutputBuilder() {
    }

    public GetAsyncOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetAsyncOutputBuilder(AsyncBodyGrouping arg) {
        this._packetInMask = arg.getPacketInMask();
        this._portStatusMask = arg.getPortStatusMask();
        this._flowRemovedMask = arg.getFlowRemovedMask();
    }

    public GetAsyncOutputBuilder(GetAsyncOutput base) {
        AugmentationHolder casted;
        this._flowRemovedMask = base.getFlowRemovedMask();
        this._packetInMask = base.getPacketInMask();
        this._portStatusMask = base.getPortStatusMask();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof GetAsyncOutputImpl) {
            GetAsyncOutputImpl impl = (GetAsyncOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof AsyncBodyGrouping) {
            this._packetInMask = ((AsyncBodyGrouping)arg).getPacketInMask();
            this._portStatusMask = ((AsyncBodyGrouping)arg).getPortStatusMask();
            this._flowRemovedMask = ((AsyncBodyGrouping)arg).getFlowRemovedMask();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.AsyncBodyGrouping] \nbut was: " + arg);
        }
    }

    public List<FlowRemovedMask> getFlowRemovedMask() {
        return this._flowRemovedMask;
    }

    public List<PacketInMask> getPacketInMask() {
        return this._packetInMask;
    }

    public List<PortStatusMask> getPortStatusMask() {
        return this._portStatusMask;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetAsyncOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetAsyncOutputBuilder setFlowRemovedMask(List<FlowRemovedMask> value) {
        this._flowRemovedMask = value;
        return this;
    }

    public GetAsyncOutputBuilder setPacketInMask(List<PacketInMask> value) {
        this._packetInMask = value;
        return this;
    }

    public GetAsyncOutputBuilder setPortStatusMask(List<PortStatusMask> value) {
        this._portStatusMask = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetAsyncOutputBuilder setVersion(Short value) {
        if (value != null) {
            GetAsyncOutputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetAsyncOutputBuilder setXid(Long value) {
        if (value != null) {
            GetAsyncOutputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetAsyncOutputBuilder addAugmentation(Class<? extends Augmentation<GetAsyncOutput>> augmentationType, Augmentation<GetAsyncOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetAsyncOutputBuilder removeAugmentation(Class<? extends Augmentation<GetAsyncOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetAsyncOutput build() {
        return new GetAsyncOutputImpl(this);
    }

    private static final class GetAsyncOutputImpl
    implements GetAsyncOutput {
        private final List<FlowRemovedMask> _flowRemovedMask;
        private final List<PacketInMask> _packetInMask;
        private final List<PortStatusMask> _portStatusMask;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetAsyncOutput> getImplementedInterface() {
            return GetAsyncOutput.class;
        }

        private GetAsyncOutputImpl(GetAsyncOutputBuilder base) {
            this._flowRemovedMask = base.getFlowRemovedMask();
            this._packetInMask = base.getPacketInMask();
            this._portStatusMask = base.getPortStatusMask();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<FlowRemovedMask> getFlowRemovedMask() {
            return this._flowRemovedMask;
        }

        @Override
        public List<PacketInMask> getPacketInMask() {
            return this._packetInMask;
        }

        @Override
        public List<PortStatusMask> getPortStatusMask() {
            return this._portStatusMask;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetAsyncOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowRemovedMask);
            result = 31 * result + Objects.hashCode(this._packetInMask);
            result = 31 * result + Objects.hashCode(this._portStatusMask);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetAsyncOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetAsyncOutput other = (GetAsyncOutput)obj;
            if (!Objects.equals(this._flowRemovedMask, other.getFlowRemovedMask())) {
                return false;
            }
            if (!Objects.equals(this._packetInMask, other.getPacketInMask())) {
                return false;
            }
            if (!Objects.equals(this._portStatusMask, other.getPortStatusMask())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetAsyncOutputImpl otherImpl = (GetAsyncOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetAsyncOutput>>, Augmentation<GetAsyncOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GetAsyncOutput [");
            boolean first = true;
            if (this._flowRemovedMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowRemovedMask=");
                builder.append(this._flowRemovedMask);
            }
            if (this._packetInMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetInMask=");
                builder.append(this._packetInMask);
            }
            if (this._portStatusMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portStatusMask=");
                builder.append(this._portStatusMask);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

