/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetConfigOutputBuilder
implements Builder<GetConfigOutput> {
    private SwitchConfigFlag _flags;
    private Integer _missSendLen;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> augmentation = Collections.emptyMap();

    public GetConfigOutputBuilder() {
    }

    public GetConfigOutputBuilder(GetConfigReply arg) {
        this._flags = arg.getFlags();
        this._missSendLen = arg.getMissSendLen();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetConfigOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetConfigOutputBuilder(GetConfigOutput base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._missSendLen = base.getMissSendLen();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof GetConfigOutputImpl) {
            GetConfigOutputImpl impl = (GetConfigOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof GetConfigReply) {
            this._flags = ((GetConfigReply)arg).getFlags();
            this._missSendLen = ((GetConfigReply)arg).getMissSendLen();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigReply] \nbut was: " + arg);
        }
    }

    public SwitchConfigFlag getFlags() {
        return this._flags;
    }

    public Integer getMissSendLen() {
        return this._missSendLen;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetConfigOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetConfigOutputBuilder setFlags(SwitchConfigFlag value) {
        this._flags = value;
        return this;
    }

    private static void checkMissSendLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public GetConfigOutputBuilder setMissSendLen(Integer value) {
        if (value != null) {
            GetConfigOutputBuilder.checkMissSendLenRange(value);
        }
        this._missSendLen = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetConfigOutputBuilder setVersion(Short value) {
        if (value != null) {
            GetConfigOutputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetConfigOutputBuilder setXid(Long value) {
        if (value != null) {
            GetConfigOutputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetConfigOutputBuilder addAugmentation(Class<? extends Augmentation<GetConfigOutput>> augmentationType, Augmentation<GetConfigOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetConfigOutputBuilder removeAugmentation(Class<? extends Augmentation<GetConfigOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetConfigOutput build() {
        return new GetConfigOutputImpl(this);
    }

    private static final class GetConfigOutputImpl
    implements GetConfigOutput {
        private final SwitchConfigFlag _flags;
        private final Integer _missSendLen;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetConfigOutput> getImplementedInterface() {
            return GetConfigOutput.class;
        }

        private GetConfigOutputImpl(GetConfigOutputBuilder base) {
            this._flags = base.getFlags();
            this._missSendLen = base.getMissSendLen();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public SwitchConfigFlag getFlags() {
            return this._flags;
        }

        @Override
        public Integer getMissSendLen() {
            return this._missSendLen;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetConfigOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._flags);
            result = 31 * result + Objects.hashCode(this._missSendLen);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetConfigOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetConfigOutput other = (GetConfigOutput)obj;
            if (!Objects.equals((Object)this._flags, (Object)other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._missSendLen, other.getMissSendLen())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetConfigOutputImpl otherImpl = (GetConfigOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GetConfigOutput [");
            boolean first = true;
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append((Object)this._flags);
            }
            if (this._missSendLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_missSendLen=");
                builder.append(this._missSendLen);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

