/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FeaturesReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetFeaturesOutputBuilder
implements Builder<GetFeaturesOutput> {
    private ActionTypeV10 _actionsV10;
    private Short _auxiliaryId;
    private Long _buffers;
    private Capabilities _capabilities;
    private CapabilitiesV10 _capabilitiesV10;
    private BigInteger _datapathId;
    private List<PhyPort> _phyPort;
    private Long _reserved;
    private Short _tables;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDATAPATHIDRANGE_RANGES;

    public GetFeaturesOutputBuilder() {
    }

    public GetFeaturesOutputBuilder(FeaturesReply arg) {
        this._datapathId = arg.getDatapathId();
        this._buffers = arg.getBuffers();
        this._tables = arg.getTables();
        this._auxiliaryId = arg.getAuxiliaryId();
        this._capabilities = arg.getCapabilities();
        this._reserved = arg.getReserved();
        this._capabilitiesV10 = arg.getCapabilitiesV10();
        this._actionsV10 = arg.getActionsV10();
        this._phyPort = arg.getPhyPort();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetFeaturesOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetFeaturesOutputBuilder(GetFeaturesOutput base) {
        AugmentationHolder casted;
        this._actionsV10 = base.getActionsV10();
        this._auxiliaryId = base.getAuxiliaryId();
        this._buffers = base.getBuffers();
        this._capabilities = base.getCapabilities();
        this._capabilitiesV10 = base.getCapabilitiesV10();
        this._datapathId = base.getDatapathId();
        this._phyPort = base.getPhyPort();
        this._reserved = base.getReserved();
        this._tables = base.getTables();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof GetFeaturesOutputImpl) {
            GetFeaturesOutputImpl impl = (GetFeaturesOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FeaturesReply) {
            this._datapathId = ((FeaturesReply)arg).getDatapathId();
            this._buffers = ((FeaturesReply)arg).getBuffers();
            this._tables = ((FeaturesReply)arg).getTables();
            this._auxiliaryId = ((FeaturesReply)arg).getAuxiliaryId();
            this._capabilities = ((FeaturesReply)arg).getCapabilities();
            this._reserved = ((FeaturesReply)arg).getReserved();
            this._capabilitiesV10 = ((FeaturesReply)arg).getCapabilitiesV10();
            this._actionsV10 = ((FeaturesReply)arg).getActionsV10();
            this._phyPort = ((FeaturesReply)arg).getPhyPort();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FeaturesReply, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public ActionTypeV10 getActionsV10() {
        return this._actionsV10;
    }

    public Short getAuxiliaryId() {
        return this._auxiliaryId;
    }

    public Long getBuffers() {
        return this._buffers;
    }

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public CapabilitiesV10 getCapabilitiesV10() {
        return this._capabilitiesV10;
    }

    public BigInteger getDatapathId() {
        return this._datapathId;
    }

    public List<PhyPort> getPhyPort() {
        return this._phyPort;
    }

    public Long getReserved() {
        return this._reserved;
    }

    public Short getTables() {
        return this._tables;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetFeaturesOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetFeaturesOutputBuilder setActionsV10(ActionTypeV10 value) {
        this._actionsV10 = value;
        return this;
    }

    private static void checkAuxiliaryIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetFeaturesOutputBuilder setAuxiliaryId(Short value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkAuxiliaryIdRange(value);
        }
        this._auxiliaryId = value;
        return this;
    }

    private static void checkBuffersRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetFeaturesOutputBuilder setBuffers(Long value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkBuffersRange(value);
        }
        this._buffers = value;
        return this;
    }

    public GetFeaturesOutputBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public GetFeaturesOutputBuilder setCapabilitiesV10(CapabilitiesV10 value) {
        this._capabilitiesV10 = value;
        return this;
    }

    private static void checkDatapathIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDATAPATHIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDATAPATHIDRANGE_RANGES)));
    }

    public GetFeaturesOutputBuilder setDatapathId(BigInteger value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkDatapathIdRange(value);
        }
        this._datapathId = value;
        return this;
    }

    public GetFeaturesOutputBuilder setPhyPort(List<PhyPort> value) {
        this._phyPort = value;
        return this;
    }

    private static void checkReservedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetFeaturesOutputBuilder setReserved(Long value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkReservedRange(value);
        }
        this._reserved = value;
        return this;
    }

    private static void checkTablesRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetFeaturesOutputBuilder setTables(Short value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkTablesRange(value);
        }
        this._tables = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetFeaturesOutputBuilder setVersion(Short value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetFeaturesOutputBuilder setXid(Long value) {
        if (value != null) {
            GetFeaturesOutputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetFeaturesOutputBuilder addAugmentation(Class<? extends Augmentation<GetFeaturesOutput>> augmentationType, Augmentation<GetFeaturesOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetFeaturesOutputBuilder removeAugmentation(Class<? extends Augmentation<GetFeaturesOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetFeaturesOutput build() {
        return new GetFeaturesOutputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDATAPATHIDRANGE_RANGES = a;
    }

    private static final class GetFeaturesOutputImpl
    implements GetFeaturesOutput {
        private final ActionTypeV10 _actionsV10;
        private final Short _auxiliaryId;
        private final Long _buffers;
        private final Capabilities _capabilities;
        private final CapabilitiesV10 _capabilitiesV10;
        private final BigInteger _datapathId;
        private final List<PhyPort> _phyPort;
        private final Long _reserved;
        private final Short _tables;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetFeaturesOutput> getImplementedInterface() {
            return GetFeaturesOutput.class;
        }

        private GetFeaturesOutputImpl(GetFeaturesOutputBuilder base) {
            this._actionsV10 = base.getActionsV10();
            this._auxiliaryId = base.getAuxiliaryId();
            this._buffers = base.getBuffers();
            this._capabilities = base.getCapabilities();
            this._capabilitiesV10 = base.getCapabilitiesV10();
            this._datapathId = base.getDatapathId();
            this._phyPort = base.getPhyPort();
            this._reserved = base.getReserved();
            this._tables = base.getTables();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public ActionTypeV10 getActionsV10() {
            return this._actionsV10;
        }

        @Override
        public Short getAuxiliaryId() {
            return this._auxiliaryId;
        }

        @Override
        public Long getBuffers() {
            return this._buffers;
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public CapabilitiesV10 getCapabilitiesV10() {
            return this._capabilitiesV10;
        }

        @Override
        public BigInteger getDatapathId() {
            return this._datapathId;
        }

        @Override
        public List<PhyPort> getPhyPort() {
            return this._phyPort;
        }

        @Override
        public Long getReserved() {
            return this._reserved;
        }

        @Override
        public Short getTables() {
            return this._tables;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetFeaturesOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._actionsV10);
            result = 31 * result + Objects.hashCode(this._auxiliaryId);
            result = 31 * result + Objects.hashCode(this._buffers);
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._capabilitiesV10);
            result = 31 * result + Objects.hashCode(this._datapathId);
            result = 31 * result + Objects.hashCode(this._phyPort);
            result = 31 * result + Objects.hashCode(this._reserved);
            result = 31 * result + Objects.hashCode(this._tables);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetFeaturesOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetFeaturesOutput other = (GetFeaturesOutput)obj;
            if (!Objects.equals(this._actionsV10, other.getActionsV10())) {
                return false;
            }
            if (!Objects.equals(this._auxiliaryId, other.getAuxiliaryId())) {
                return false;
            }
            if (!Objects.equals(this._buffers, other.getBuffers())) {
                return false;
            }
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._capabilitiesV10, other.getCapabilitiesV10())) {
                return false;
            }
            if (!Objects.equals(this._datapathId, other.getDatapathId())) {
                return false;
            }
            if (!Objects.equals(this._phyPort, other.getPhyPort())) {
                return false;
            }
            if (!Objects.equals(this._reserved, other.getReserved())) {
                return false;
            }
            if (!Objects.equals(this._tables, other.getTables())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetFeaturesOutputImpl otherImpl = (GetFeaturesOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GetFeaturesOutput [");
            boolean first = true;
            if (this._actionsV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_actionsV10=");
                builder.append(this._actionsV10);
            }
            if (this._auxiliaryId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_auxiliaryId=");
                builder.append(this._auxiliaryId);
            }
            if (this._buffers != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_buffers=");
                builder.append(this._buffers);
            }
            if (this._capabilities != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_capabilities=");
                builder.append(this._capabilities);
            }
            if (this._capabilitiesV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_capabilitiesV10=");
                builder.append(this._capabilitiesV10);
            }
            if (this._datapathId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_datapathId=");
                builder.append(this._datapathId);
            }
            if (this._phyPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_phyPort=");
                builder.append(this._phyPort);
            }
            if (this._reserved != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reserved=");
                builder.append(this._reserved);
            }
            if (this._tables != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tables=");
                builder.append(this._tables);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

