/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueueGetConfigRequest;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetQueueConfigInputBuilder
implements Builder<GetQueueConfigInput> {
    private PortNumber _port;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>> augmentation = Collections.emptyMap();

    public GetQueueConfigInputBuilder() {
    }

    public GetQueueConfigInputBuilder(QueueGetConfigRequest arg) {
        this._port = arg.getPort();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetQueueConfigInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetQueueConfigInputBuilder(GetQueueConfigInput base) {
        AugmentationHolder casted;
        this._port = base.getPort();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof GetQueueConfigInputImpl) {
            GetQueueConfigInputImpl impl = (GetQueueConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueueGetConfigRequest) {
            this._port = ((QueueGetConfigRequest)arg).getPort();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueueGetConfigRequest, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetQueueConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetQueueConfigInputBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GetQueueConfigInputBuilder setVersion(Short value) {
        if (value != null) {
            GetQueueConfigInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetQueueConfigInputBuilder setXid(Long value) {
        if (value != null) {
            GetQueueConfigInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetQueueConfigInputBuilder addAugmentation(Class<? extends Augmentation<GetQueueConfigInput>> augmentationType, Augmentation<GetQueueConfigInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetQueueConfigInputBuilder removeAugmentation(Class<? extends Augmentation<GetQueueConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetQueueConfigInput build() {
        return new GetQueueConfigInputImpl(this);
    }

    private static final class GetQueueConfigInputImpl
    implements GetQueueConfigInput {
        private final PortNumber _port;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetQueueConfigInput> getImplementedInterface() {
            return GetQueueConfigInput.class;
        }

        private GetQueueConfigInputImpl(GetQueueConfigInputBuilder base) {
            this._port = base.getPort();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>>(base.augmentation);
                }
            }
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetQueueConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetQueueConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetQueueConfigInput other = (GetQueueConfigInput)obj;
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetQueueConfigInputImpl otherImpl = (GetQueueConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetQueueConfigInput>>, Augmentation<GetQueueConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GetQueueConfigInput [");
            boolean first = true;
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

