/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupModInputBuilder
implements Builder<GroupModInput> {
    private List<BucketsList> _bucketsList;
    private GroupModCommand _command;
    private GroupId _groupId;
    private GroupType _type;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> augmentation = Collections.emptyMap();

    public GroupModInputBuilder() {
    }

    public GroupModInputBuilder(GroupMod arg) {
        this._command = arg.getCommand();
        this._type = arg.getType();
        this._groupId = arg.getGroupId();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._bucketsList = arg.getBucketsList();
    }

    public GroupModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GroupModInputBuilder(BucketsGrouping arg) {
        this._bucketsList = arg.getBucketsList();
    }

    public GroupModInputBuilder(GroupModInput base) {
        AugmentationHolder casted;
        this._bucketsList = base.getBucketsList();
        this._command = base.getCommand();
        this._groupId = base.getGroupId();
        this._type = base.getType();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof GroupModInputImpl) {
            GroupModInputImpl impl = (GroupModInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BucketsGrouping) {
            this._bucketsList = ((BucketsGrouping)arg).getBucketsList();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof GroupMod) {
            this._command = ((GroupMod)arg).getCommand();
            this._type = ((GroupMod)arg).getType();
            this._groupId = ((GroupMod)arg).getGroupId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupMod] \nbut was: " + arg);
        }
    }

    public List<BucketsList> getBucketsList() {
        return this._bucketsList;
    }

    public GroupModCommand getCommand() {
        return this._command;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public GroupType getType() {
        return this._type;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GroupModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupModInputBuilder setBucketsList(List<BucketsList> value) {
        this._bucketsList = value;
        return this;
    }

    public GroupModInputBuilder setCommand(GroupModCommand value) {
        this._command = value;
        return this;
    }

    public GroupModInputBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupModInputBuilder setType(GroupType value) {
        this._type = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GroupModInputBuilder setVersion(Short value) {
        if (value != null) {
            GroupModInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GroupModInputBuilder setXid(Long value) {
        if (value != null) {
            GroupModInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GroupModInputBuilder addAugmentation(Class<? extends Augmentation<GroupModInput>> augmentationType, Augmentation<GroupModInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupModInputBuilder removeAugmentation(Class<? extends Augmentation<GroupModInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GroupModInput build() {
        return new GroupModInputImpl(this);
    }

    private static final class GroupModInputImpl
    implements GroupModInput {
        private final List<BucketsList> _bucketsList;
        private final GroupModCommand _command;
        private final GroupId _groupId;
        private final GroupType _type;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GroupModInput> getImplementedInterface() {
            return GroupModInput.class;
        }

        private GroupModInputImpl(GroupModInputBuilder base) {
            this._bucketsList = base.getBucketsList();
            this._command = base.getCommand();
            this._groupId = base.getGroupId();
            this._type = base.getType();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BucketsList> getBucketsList() {
            return this._bucketsList;
        }

        @Override
        public GroupModCommand getCommand() {
            return this._command;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public GroupType getType() {
            return this._type;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GroupModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bucketsList);
            result = 31 * result + Objects.hashCode((Object)this._command);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode((Object)this._type);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GroupModInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GroupModInput other = (GroupModInput)obj;
            if (!Objects.equals(this._bucketsList, other.getBucketsList())) {
                return false;
            }
            if (!Objects.equals((Object)this._command, (Object)other.getCommand())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GroupModInputImpl otherImpl = (GroupModInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GroupModInput [");
            boolean first = true;
            if (this._bucketsList != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bucketsList=");
                builder.append(this._bucketsList);
            }
            if (this._command != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_command=");
                builder.append((Object)this._command);
            }
            if (this._groupId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupId=");
                builder.append(this._groupId);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

