/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterModInputBuilder
implements Builder<MeterModInput> {
    private List<Bands> _bands;
    private MeterModCommand _command;
    private MeterFlags _flags;
    private MeterId _meterId;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> augmentation = Collections.emptyMap();

    public MeterModInputBuilder() {
    }

    public MeterModInputBuilder(MeterMod arg) {
        this._command = arg.getCommand();
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._bands = arg.getBands();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MeterModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MeterModInputBuilder(MeterModInput base) {
        AugmentationHolder casted;
        this._bands = base.getBands();
        this._command = base.getCommand();
        this._flags = base.getFlags();
        this._meterId = base.getMeterId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof MeterModInputImpl) {
            MeterModInputImpl impl = (MeterModInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MeterMod) {
            this._command = ((MeterMod)arg).getCommand();
            this._flags = ((MeterMod)arg).getFlags();
            this._meterId = ((MeterMod)arg).getMeterId();
            this._bands = ((MeterMod)arg).getBands();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterMod, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public List<Bands> getBands() {
        return this._bands;
    }

    public MeterModCommand getCommand() {
        return this._command;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<MeterModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterModInputBuilder setBands(List<Bands> value) {
        this._bands = value;
        return this;
    }

    public MeterModInputBuilder setCommand(MeterModCommand value) {
        this._command = value;
        return this;
    }

    public MeterModInputBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterModInputBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MeterModInputBuilder setVersion(Short value) {
        if (value != null) {
            MeterModInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterModInputBuilder setXid(Long value) {
        if (value != null) {
            MeterModInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public MeterModInputBuilder addAugmentation(Class<? extends Augmentation<MeterModInput>> augmentationType, Augmentation<MeterModInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterModInputBuilder removeAugmentation(Class<? extends Augmentation<MeterModInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MeterModInput build() {
        return new MeterModInputImpl(this);
    }

    private static final class MeterModInputImpl
    implements MeterModInput {
        private final List<Bands> _bands;
        private final MeterModCommand _command;
        private final MeterFlags _flags;
        private final MeterId _meterId;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MeterModInput> getImplementedInterface() {
            return MeterModInput.class;
        }

        private MeterModInputImpl(MeterModInputBuilder base) {
            this._bands = base.getBands();
            this._command = base.getCommand();
            this._flags = base.getFlags();
            this._meterId = base.getMeterId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Bands> getBands() {
            return this._bands;
        }

        @Override
        public MeterModCommand getCommand() {
            return this._command;
        }

        @Override
        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<MeterModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bands);
            result = 31 * result + Objects.hashCode((Object)this._command);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._meterId);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MeterModInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MeterModInput other = (MeterModInput)obj;
            if (!Objects.equals(this._bands, other.getBands())) {
                return false;
            }
            if (!Objects.equals((Object)this._command, (Object)other.getCommand())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterModInputImpl otherImpl = (MeterModInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MeterModInput [");
            boolean first = true;
            if (this._bands != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bands=");
                builder.append(this._bands);
            }
            if (this._command != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_command=");
                builder.append((Object)this._command);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

