/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestInputBuilder
implements Builder<MultipartRequestInput> {
    private MultipartRequestFlags _flags;
    private MultipartRequestBody _multipartRequestBody;
    private MultipartType _type;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> augmentation = Collections.emptyMap();

    public MultipartRequestInputBuilder() {
    }

    public MultipartRequestInputBuilder(MultipartRequest arg) {
        this._type = arg.getType();
        this._flags = arg.getFlags();
        this._multipartRequestBody = arg.getMultipartRequestBody();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MultipartRequestInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MultipartRequestInputBuilder(MultipartRequestInput base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._multipartRequestBody = base.getMultipartRequestBody();
        this._type = base.getType();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof MultipartRequestInputImpl) {
            MultipartRequestInputImpl impl = (MultipartRequestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MultipartRequest) {
            this._type = ((MultipartRequest)arg).getType();
            this._flags = ((MultipartRequest)arg).getFlags();
            this._multipartRequestBody = ((MultipartRequest)arg).getMultipartRequestBody();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequest, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public MultipartRequestFlags getFlags() {
        return this._flags;
    }

    public MultipartRequestBody getMultipartRequestBody() {
        return this._multipartRequestBody;
    }

    public MultipartType getType() {
        return this._type;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<MultipartRequestInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartRequestInputBuilder setFlags(MultipartRequestFlags value) {
        this._flags = value;
        return this;
    }

    public MultipartRequestInputBuilder setMultipartRequestBody(MultipartRequestBody value) {
        this._multipartRequestBody = value;
        return this;
    }

    public MultipartRequestInputBuilder setType(MultipartType value) {
        this._type = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MultipartRequestInputBuilder setVersion(Short value) {
        if (value != null) {
            MultipartRequestInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestInputBuilder setXid(Long value) {
        if (value != null) {
            MultipartRequestInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public MultipartRequestInputBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestInput>> augmentationType, Augmentation<MultipartRequestInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestInputBuilder removeAugmentation(Class<? extends Augmentation<MultipartRequestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartRequestInput build() {
        return new MultipartRequestInputImpl(this);
    }

    private static final class MultipartRequestInputImpl
    implements MultipartRequestInput {
        private final MultipartRequestFlags _flags;
        private final MultipartRequestBody _multipartRequestBody;
        private final MultipartType _type;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartRequestInput> getImplementedInterface() {
            return MultipartRequestInput.class;
        }

        private MultipartRequestInputImpl(MultipartRequestInputBuilder base) {
            this._flags = base.getFlags();
            this._multipartRequestBody = base.getMultipartRequestBody();
            this._type = base.getType();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>(base.augmentation);
                }
            }
        }

        @Override
        public MultipartRequestFlags getFlags() {
            return this._flags;
        }

        @Override
        public MultipartRequestBody getMultipartRequestBody() {
            return this._multipartRequestBody;
        }

        @Override
        public MultipartType getType() {
            return this._type;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<MultipartRequestInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._multipartRequestBody);
            result = 31 * result + Objects.hashCode((Object)this._type);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartRequestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartRequestInput other = (MultipartRequestInput)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._multipartRequestBody, other.getMultipartRequestBody())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartRequestInputImpl otherImpl = (MultipartRequestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartRequestInput [");
            boolean first = true;
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._multipartRequestBody != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_multipartRequestBody=");
                builder.append(this._multipartRequestBody);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

