/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketInMessageBuilder
implements Builder<PacketInMessage> {
    private Long _bufferId;
    private BigInteger _cookie;
    private byte[] _data;
    private Integer _inPort;
    private Match _match;
    private PacketInReason _reason;
    private TableId _tableId;
    private Integer _totalLen;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;

    public PacketInMessageBuilder() {
    }

    public PacketInMessageBuilder(PacketIn arg) {
        this._bufferId = arg.getBufferId();
        this._totalLen = arg.getTotalLen();
        this._reason = arg.getReason();
        this._tableId = arg.getTableId();
        this._cookie = arg.getCookie();
        this._data = arg.getData();
        this._inPort = arg.getInPort();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._match = arg.getMatch();
    }

    public PacketInMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PacketInMessageBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public PacketInMessageBuilder(PacketInMessage base) {
        AugmentationHolder casted;
        this._bufferId = base.getBufferId();
        this._cookie = base.getCookie();
        this._data = base.getData();
        this._inPort = base.getInPort();
        this._match = base.getMatch();
        this._reason = base.getReason();
        this._tableId = base.getTableId();
        this._totalLen = base.getTotalLen();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof PacketInMessageImpl) {
            PacketInMessageImpl impl = (PacketInMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PacketIn) {
            this._bufferId = ((PacketIn)arg).getBufferId();
            this._totalLen = ((PacketIn)arg).getTotalLen();
            this._reason = ((PacketIn)arg).getReason();
            this._tableId = ((PacketIn)arg).getTableId();
            this._cookie = ((PacketIn)arg).getCookie();
            this._data = ((PacketIn)arg).getData();
            this._inPort = ((PacketIn)arg).getInPort();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketIn, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping] \nbut was: " + arg);
        }
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public byte[] getData() {
        return this._data == null ? null : (byte[])this._data.clone();
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Match getMatch() {
        return this._match;
    }

    public PacketInReason getReason() {
        return this._reason;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public Integer getTotalLen() {
        return this._totalLen;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PacketInMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketInMessageBuilder setBufferId(Long value) {
        if (value != null) {
            PacketInMessageBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public PacketInMessageBuilder setCookie(BigInteger value) {
        if (value != null) {
            PacketInMessageBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    public PacketInMessageBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    private static void checkInPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public PacketInMessageBuilder setInPort(Integer value) {
        if (value != null) {
            PacketInMessageBuilder.checkInPortRange(value);
        }
        this._inPort = value;
        return this;
    }

    public PacketInMessageBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public PacketInMessageBuilder setReason(PacketInReason value) {
        this._reason = value;
        return this;
    }

    public PacketInMessageBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    private static void checkTotalLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public PacketInMessageBuilder setTotalLen(Integer value) {
        if (value != null) {
            PacketInMessageBuilder.checkTotalLenRange(value);
        }
        this._totalLen = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PacketInMessageBuilder setVersion(Short value) {
        if (value != null) {
            PacketInMessageBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketInMessageBuilder setXid(Long value) {
        if (value != null) {
            PacketInMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public PacketInMessageBuilder addAugmentation(Class<? extends Augmentation<PacketInMessage>> augmentationType, Augmentation<PacketInMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketInMessageBuilder removeAugmentation(Class<? extends Augmentation<PacketInMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketInMessage build() {
        return new PacketInMessageImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
    }

    private static final class PacketInMessageImpl
    implements PacketInMessage {
        private final Long _bufferId;
        private final BigInteger _cookie;
        private final byte[] _data;
        private final Integer _inPort;
        private final Match _match;
        private final PacketInReason _reason;
        private final TableId _tableId;
        private final Integer _totalLen;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketInMessage> getImplementedInterface() {
            return PacketInMessage.class;
        }

        private PacketInMessageImpl(PacketInMessageBuilder base) {
            this._bufferId = base.getBufferId();
            this._cookie = base.getCookie();
            this._data = base.getData();
            this._inPort = base.getInPort();
            this._match = base.getMatch();
            this._reason = base.getReason();
            this._tableId = base.getTableId();
            this._totalLen = base.getTotalLen();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public byte[] getData() {
            return this._data == null ? null : (byte[])this._data.clone();
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public PacketInReason getReason() {
            return this._reason;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public Integer getTotalLen() {
            return this._totalLen;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PacketInMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bufferId);
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Arrays.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode((Object)this._reason);
            result = 31 * result + Objects.hashCode(this._tableId);
            result = 31 * result + Objects.hashCode(this._totalLen);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketInMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketInMessage other = (PacketInMessage)obj;
            if (!Objects.equals(this._bufferId, other.getBufferId())) {
                return false;
            }
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Arrays.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals((Object)this._reason, (Object)other.getReason())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (!Objects.equals(this._totalLen, other.getTotalLen())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketInMessageImpl otherImpl = (PacketInMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PacketInMessage [");
            boolean first = true;
            if (this._bufferId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bufferId=");
                builder.append(this._bufferId);
            }
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._data != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_data=");
                builder.append(Arrays.toString(this._data));
            }
            if (this._inPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPort=");
                builder.append(this._inPort);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append((Object)this._reason);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._totalLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_totalLen=");
                builder.append(this._totalLen);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

