/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketOutInputBuilder
implements Builder<PacketOutInput> {
    private List<Action> _action;
    private Long _bufferId;
    private byte[] _data;
    private PortNumber _inPort;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>> augmentation = Collections.emptyMap();

    public PacketOutInputBuilder() {
    }

    public PacketOutInputBuilder(PacketOut arg) {
        this._data = arg.getData();
        this._bufferId = arg.getBufferId();
        this._inPort = arg.getInPort();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._action = arg.getAction();
    }

    public PacketOutInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PacketOutInputBuilder(ActionsGrouping arg) {
        this._action = arg.getAction();
    }

    public PacketOutInputBuilder(PacketOutInput base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._bufferId = base.getBufferId();
        this._data = base.getData();
        this._inPort = base.getInPort();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof PacketOutInputImpl) {
            PacketOutInputImpl impl = (PacketOutInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PacketOut) {
            this._data = ((PacketOut)arg).getData();
            this._bufferId = ((PacketOut)arg).getBufferId();
            this._inPort = ((PacketOut)arg).getInPort();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof ActionsGrouping) {
            this._action = ((ActionsGrouping)arg).getAction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOut, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public byte[] getData() {
        return this._data == null ? null : (byte[])this._data.clone();
    }

    public PortNumber getInPort() {
        return this._inPort;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PacketOutInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketOutInputBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketOutInputBuilder setBufferId(Long value) {
        if (value != null) {
            PacketOutInputBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    public PacketOutInputBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public PacketOutInputBuilder setInPort(PortNumber value) {
        this._inPort = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PacketOutInputBuilder setVersion(Short value) {
        if (value != null) {
            PacketOutInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketOutInputBuilder setXid(Long value) {
        if (value != null) {
            PacketOutInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public PacketOutInputBuilder addAugmentation(Class<? extends Augmentation<PacketOutInput>> augmentationType, Augmentation<PacketOutInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketOutInputBuilder removeAugmentation(Class<? extends Augmentation<PacketOutInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketOutInput build() {
        return new PacketOutInputImpl(this);
    }

    private static final class PacketOutInputImpl
    implements PacketOutInput {
        private final List<Action> _action;
        private final Long _bufferId;
        private final byte[] _data;
        private final PortNumber _inPort;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketOutInput> getImplementedInterface() {
            return PacketOutInput.class;
        }

        private PacketOutInputImpl(PacketOutInputBuilder base) {
            this._action = base.getAction();
            this._bufferId = base.getBufferId();
            this._data = base.getData();
            this._inPort = base.getInPort();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public byte[] getData() {
            return this._data == null ? null : (byte[])this._data.clone();
        }

        @Override
        public PortNumber getInPort() {
            return this._inPort;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PacketOutInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._bufferId);
            result = 31 * result + Arrays.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketOutInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketOutInput other = (PacketOutInput)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._bufferId, other.getBufferId())) {
                return false;
            }
            if (!Arrays.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketOutInputImpl otherImpl = (PacketOutInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketOutInput>>, Augmentation<PacketOutInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PacketOutInput [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._bufferId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bufferId=");
                builder.append(this._bufferId);
            }
            if (this._data != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_data=");
                builder.append(Arrays.toString(this._data));
            }
            if (this._inPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPort=");
                builder.append(this._inPort);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

