/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortModInputBuilder
implements Builder<PortModInput> {
    private PortFeatures _advertise;
    private PortFeaturesV10 _advertiseV10;
    private PortConfig _config;
    private PortConfigV10 _configV10;
    private MacAddress _hwAddress;
    private PortConfig _mask;
    private PortConfigV10 _maskV10;
    private PortNumber _portNo;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> augmentation = Collections.emptyMap();

    public PortModInputBuilder() {
    }

    public PortModInputBuilder(PortMod arg) {
        this._portNo = arg.getPortNo();
        this._hwAddress = arg.getHwAddress();
        this._config = arg.getConfig();
        this._mask = arg.getMask();
        this._advertise = arg.getAdvertise();
        this._configV10 = arg.getConfigV10();
        this._maskV10 = arg.getMaskV10();
        this._advertiseV10 = arg.getAdvertiseV10();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PortModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PortModInputBuilder(PortModInput base) {
        AugmentationHolder casted;
        this._advertise = base.getAdvertise();
        this._advertiseV10 = base.getAdvertiseV10();
        this._config = base.getConfig();
        this._configV10 = base.getConfigV10();
        this._hwAddress = base.getHwAddress();
        this._mask = base.getMask();
        this._maskV10 = base.getMaskV10();
        this._portNo = base.getPortNo();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof PortModInputImpl) {
            PortModInputImpl impl = (PortModInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PortMod) {
            this._portNo = ((PortMod)arg).getPortNo();
            this._hwAddress = ((PortMod)arg).getHwAddress();
            this._config = ((PortMod)arg).getConfig();
            this._mask = ((PortMod)arg).getMask();
            this._advertise = ((PortMod)arg).getAdvertise();
            this._configV10 = ((PortMod)arg).getConfigV10();
            this._maskV10 = ((PortMod)arg).getMaskV10();
            this._advertiseV10 = ((PortMod)arg).getAdvertiseV10();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortMod, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertise() {
        return this._advertise;
    }

    public PortFeaturesV10 getAdvertiseV10() {
        return this._advertiseV10;
    }

    public PortConfig getConfig() {
        return this._config;
    }

    public PortConfigV10 getConfigV10() {
        return this._configV10;
    }

    public MacAddress getHwAddress() {
        return this._hwAddress;
    }

    public PortConfig getMask() {
        return this._mask;
    }

    public PortConfigV10 getMaskV10() {
        return this._maskV10;
    }

    public PortNumber getPortNo() {
        return this._portNo;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PortModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortModInputBuilder setAdvertise(PortFeatures value) {
        this._advertise = value;
        return this;
    }

    public PortModInputBuilder setAdvertiseV10(PortFeaturesV10 value) {
        this._advertiseV10 = value;
        return this;
    }

    public PortModInputBuilder setConfig(PortConfig value) {
        this._config = value;
        return this;
    }

    public PortModInputBuilder setConfigV10(PortConfigV10 value) {
        this._configV10 = value;
        return this;
    }

    public PortModInputBuilder setHwAddress(MacAddress value) {
        this._hwAddress = value;
        return this;
    }

    public PortModInputBuilder setMask(PortConfig value) {
        this._mask = value;
        return this;
    }

    public PortModInputBuilder setMaskV10(PortConfigV10 value) {
        this._maskV10 = value;
        return this;
    }

    public PortModInputBuilder setPortNo(PortNumber value) {
        this._portNo = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PortModInputBuilder setVersion(Short value) {
        if (value != null) {
            PortModInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortModInputBuilder setXid(Long value) {
        if (value != null) {
            PortModInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public PortModInputBuilder addAugmentation(Class<? extends Augmentation<PortModInput>> augmentationType, Augmentation<PortModInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortModInputBuilder removeAugmentation(Class<? extends Augmentation<PortModInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortModInput build() {
        return new PortModInputImpl(this);
    }

    private static final class PortModInputImpl
    implements PortModInput {
        private final PortFeatures _advertise;
        private final PortFeaturesV10 _advertiseV10;
        private final PortConfig _config;
        private final PortConfigV10 _configV10;
        private final MacAddress _hwAddress;
        private final PortConfig _mask;
        private final PortConfigV10 _maskV10;
        private final PortNumber _portNo;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortModInput> getImplementedInterface() {
            return PortModInput.class;
        }

        private PortModInputImpl(PortModInputBuilder base) {
            this._advertise = base.getAdvertise();
            this._advertiseV10 = base.getAdvertiseV10();
            this._config = base.getConfig();
            this._configV10 = base.getConfigV10();
            this._hwAddress = base.getHwAddress();
            this._mask = base.getMask();
            this._maskV10 = base.getMaskV10();
            this._portNo = base.getPortNo();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>(base.augmentation);
                }
            }
        }

        @Override
        public PortFeatures getAdvertise() {
            return this._advertise;
        }

        @Override
        public PortFeaturesV10 getAdvertiseV10() {
            return this._advertiseV10;
        }

        @Override
        public PortConfig getConfig() {
            return this._config;
        }

        @Override
        public PortConfigV10 getConfigV10() {
            return this._configV10;
        }

        @Override
        public MacAddress getHwAddress() {
            return this._hwAddress;
        }

        @Override
        public PortConfig getMask() {
            return this._mask;
        }

        @Override
        public PortConfigV10 getMaskV10() {
            return this._maskV10;
        }

        @Override
        public PortNumber getPortNo() {
            return this._portNo;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PortModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._advertise);
            result = 31 * result + Objects.hashCode(this._advertiseV10);
            result = 31 * result + Objects.hashCode(this._config);
            result = 31 * result + Objects.hashCode(this._configV10);
            result = 31 * result + Objects.hashCode(this._hwAddress);
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._maskV10);
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortModInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortModInput other = (PortModInput)obj;
            if (!Objects.equals(this._advertise, other.getAdvertise())) {
                return false;
            }
            if (!Objects.equals(this._advertiseV10, other.getAdvertiseV10())) {
                return false;
            }
            if (!Objects.equals(this._config, other.getConfig())) {
                return false;
            }
            if (!Objects.equals(this._configV10, other.getConfigV10())) {
                return false;
            }
            if (!Objects.equals(this._hwAddress, other.getHwAddress())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._maskV10, other.getMaskV10())) {
                return false;
            }
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortModInputImpl otherImpl = (PortModInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PortModInput [");
            boolean first = true;
            if (this._advertise != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertise=");
                builder.append(this._advertise);
            }
            if (this._advertiseV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertiseV10=");
                builder.append(this._advertiseV10);
            }
            if (this._config != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_config=");
                builder.append(this._config);
            }
            if (this._configV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configV10=");
                builder.append(this._configV10);
            }
            if (this._hwAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hwAddress=");
                builder.append(this._hwAddress);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(this._mask);
            }
            if (this._maskV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maskV10=");
                builder.append(this._maskV10);
            }
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

