/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortStatusMessageBuilder
implements Builder<PortStatusMessage> {
    private PortFeatures _advertisedFeatures;
    private PortFeaturesV10 _advertisedFeaturesV10;
    private PortConfig _config;
    private PortConfigV10 _configV10;
    private Long _currSpeed;
    private PortFeatures _currentFeatures;
    private PortFeaturesV10 _currentFeaturesV10;
    private MacAddress _hwAddr;
    private Long _maxSpeed;
    private String _name;
    private PortFeatures _peerFeatures;
    private PortFeaturesV10 _peerFeaturesV10;
    private Long _portNo;
    private PortReason _reason;
    private PortState _state;
    private PortStateV10 _stateV10;
    private PortFeatures _supportedFeatures;
    private PortFeaturesV10 _supportedFeaturesV10;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>> augmentation = Collections.emptyMap();

    public PortStatusMessageBuilder() {
    }

    public PortStatusMessageBuilder(PortStatus arg) {
        this._reason = arg.getReason();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
        this._portNo = arg.getPortNo();
        this._hwAddr = arg.getHwAddr();
        this._name = arg.getName();
        this._config = arg.getConfig();
        this._state = arg.getState();
        this._currentFeatures = arg.getCurrentFeatures();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._supportedFeatures = arg.getSupportedFeatures();
        this._peerFeatures = arg.getPeerFeatures();
        this._currSpeed = arg.getCurrSpeed();
        this._maxSpeed = arg.getMaxSpeed();
        this._configV10 = arg.getConfigV10();
        this._stateV10 = arg.getStateV10();
        this._currentFeaturesV10 = arg.getCurrentFeaturesV10();
        this._advertisedFeaturesV10 = arg.getAdvertisedFeaturesV10();
        this._supportedFeaturesV10 = arg.getSupportedFeaturesV10();
        this._peerFeaturesV10 = arg.getPeerFeaturesV10();
    }

    public PortStatusMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PortStatusMessageBuilder(PortGrouping arg) {
        this._portNo = arg.getPortNo();
        this._hwAddr = arg.getHwAddr();
        this._name = arg.getName();
        this._config = arg.getConfig();
        this._state = arg.getState();
        this._currentFeatures = arg.getCurrentFeatures();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._supportedFeatures = arg.getSupportedFeatures();
        this._peerFeatures = arg.getPeerFeatures();
        this._currSpeed = arg.getCurrSpeed();
        this._maxSpeed = arg.getMaxSpeed();
        this._configV10 = arg.getConfigV10();
        this._stateV10 = arg.getStateV10();
        this._currentFeaturesV10 = arg.getCurrentFeaturesV10();
        this._advertisedFeaturesV10 = arg.getAdvertisedFeaturesV10();
        this._supportedFeaturesV10 = arg.getSupportedFeaturesV10();
        this._peerFeaturesV10 = arg.getPeerFeaturesV10();
    }

    public PortStatusMessageBuilder(PortStatusMessage base) {
        AugmentationHolder casted;
        this._advertisedFeatures = base.getAdvertisedFeatures();
        this._advertisedFeaturesV10 = base.getAdvertisedFeaturesV10();
        this._config = base.getConfig();
        this._configV10 = base.getConfigV10();
        this._currSpeed = base.getCurrSpeed();
        this._currentFeatures = base.getCurrentFeatures();
        this._currentFeaturesV10 = base.getCurrentFeaturesV10();
        this._hwAddr = base.getHwAddr();
        this._maxSpeed = base.getMaxSpeed();
        this._name = base.getName();
        this._peerFeatures = base.getPeerFeatures();
        this._peerFeaturesV10 = base.getPeerFeaturesV10();
        this._portNo = base.getPortNo();
        this._reason = base.getReason();
        this._state = base.getState();
        this._stateV10 = base.getStateV10();
        this._supportedFeatures = base.getSupportedFeatures();
        this._supportedFeaturesV10 = base.getSupportedFeaturesV10();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof PortStatusMessageImpl) {
            PortStatusMessageImpl impl = (PortStatusMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PortGrouping) {
            this._portNo = ((PortGrouping)arg).getPortNo();
            this._hwAddr = ((PortGrouping)arg).getHwAddr();
            this._name = ((PortGrouping)arg).getName();
            this._config = ((PortGrouping)arg).getConfig();
            this._state = ((PortGrouping)arg).getState();
            this._currentFeatures = ((PortGrouping)arg).getCurrentFeatures();
            this._advertisedFeatures = ((PortGrouping)arg).getAdvertisedFeatures();
            this._supportedFeatures = ((PortGrouping)arg).getSupportedFeatures();
            this._peerFeatures = ((PortGrouping)arg).getPeerFeatures();
            this._currSpeed = ((PortGrouping)arg).getCurrSpeed();
            this._maxSpeed = ((PortGrouping)arg).getMaxSpeed();
            this._configV10 = ((PortGrouping)arg).getConfigV10();
            this._stateV10 = ((PortGrouping)arg).getStateV10();
            this._currentFeaturesV10 = ((PortGrouping)arg).getCurrentFeaturesV10();
            this._advertisedFeaturesV10 = ((PortGrouping)arg).getAdvertisedFeaturesV10();
            this._supportedFeaturesV10 = ((PortGrouping)arg).getSupportedFeaturesV10();
            this._peerFeaturesV10 = ((PortGrouping)arg).getPeerFeaturesV10();
            isValidArg = true;
        }
        if (arg instanceof PortStatus) {
            this._reason = ((PortStatus)arg).getReason();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatus, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortFeaturesV10 getAdvertisedFeaturesV10() {
        return this._advertisedFeaturesV10;
    }

    public PortConfig getConfig() {
        return this._config;
    }

    public PortConfigV10 getConfigV10() {
        return this._configV10;
    }

    public Long getCurrSpeed() {
        return this._currSpeed;
    }

    public PortFeatures getCurrentFeatures() {
        return this._currentFeatures;
    }

    public PortFeaturesV10 getCurrentFeaturesV10() {
        return this._currentFeaturesV10;
    }

    public MacAddress getHwAddr() {
        return this._hwAddr;
    }

    public Long getMaxSpeed() {
        return this._maxSpeed;
    }

    public String getName() {
        return this._name;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public PortFeaturesV10 getPeerFeaturesV10() {
        return this._peerFeaturesV10;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public PortReason getReason() {
        return this._reason;
    }

    public PortState getState() {
        return this._state;
    }

    public PortStateV10 getStateV10() {
        return this._stateV10;
    }

    public PortFeatures getSupportedFeatures() {
        return this._supportedFeatures;
    }

    public PortFeaturesV10 getSupportedFeaturesV10() {
        return this._supportedFeaturesV10;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PortStatusMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortStatusMessageBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortStatusMessageBuilder setAdvertisedFeaturesV10(PortFeaturesV10 value) {
        this._advertisedFeaturesV10 = value;
        return this;
    }

    public PortStatusMessageBuilder setConfig(PortConfig value) {
        this._config = value;
        return this;
    }

    public PortStatusMessageBuilder setConfigV10(PortConfigV10 value) {
        this._configV10 = value;
        return this;
    }

    private static void checkCurrSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatusMessageBuilder setCurrSpeed(Long value) {
        if (value != null) {
            PortStatusMessageBuilder.checkCurrSpeedRange(value);
        }
        this._currSpeed = value;
        return this;
    }

    public PortStatusMessageBuilder setCurrentFeatures(PortFeatures value) {
        this._currentFeatures = value;
        return this;
    }

    public PortStatusMessageBuilder setCurrentFeaturesV10(PortFeaturesV10 value) {
        this._currentFeaturesV10 = value;
        return this;
    }

    public PortStatusMessageBuilder setHwAddr(MacAddress value) {
        this._hwAddr = value;
        return this;
    }

    private static void checkMaxSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatusMessageBuilder setMaxSpeed(Long value) {
        if (value != null) {
            PortStatusMessageBuilder.checkMaxSpeedRange(value);
        }
        this._maxSpeed = value;
        return this;
    }

    public PortStatusMessageBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PortStatusMessageBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public PortStatusMessageBuilder setPeerFeaturesV10(PortFeaturesV10 value) {
        this._peerFeaturesV10 = value;
        return this;
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatusMessageBuilder setPortNo(Long value) {
        if (value != null) {
            PortStatusMessageBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    public PortStatusMessageBuilder setReason(PortReason value) {
        this._reason = value;
        return this;
    }

    public PortStatusMessageBuilder setState(PortState value) {
        this._state = value;
        return this;
    }

    public PortStatusMessageBuilder setStateV10(PortStateV10 value) {
        this._stateV10 = value;
        return this;
    }

    public PortStatusMessageBuilder setSupportedFeatures(PortFeatures value) {
        this._supportedFeatures = value;
        return this;
    }

    public PortStatusMessageBuilder setSupportedFeaturesV10(PortFeaturesV10 value) {
        this._supportedFeaturesV10 = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PortStatusMessageBuilder setVersion(Short value) {
        if (value != null) {
            PortStatusMessageBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatusMessageBuilder setXid(Long value) {
        if (value != null) {
            PortStatusMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public PortStatusMessageBuilder addAugmentation(Class<? extends Augmentation<PortStatusMessage>> augmentationType, Augmentation<PortStatusMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortStatusMessageBuilder removeAugmentation(Class<? extends Augmentation<PortStatusMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortStatusMessage build() {
        return new PortStatusMessageImpl(this);
    }

    private static final class PortStatusMessageImpl
    implements PortStatusMessage {
        private final PortFeatures _advertisedFeatures;
        private final PortFeaturesV10 _advertisedFeaturesV10;
        private final PortConfig _config;
        private final PortConfigV10 _configV10;
        private final Long _currSpeed;
        private final PortFeatures _currentFeatures;
        private final PortFeaturesV10 _currentFeaturesV10;
        private final MacAddress _hwAddr;
        private final Long _maxSpeed;
        private final String _name;
        private final PortFeatures _peerFeatures;
        private final PortFeaturesV10 _peerFeaturesV10;
        private final Long _portNo;
        private final PortReason _reason;
        private final PortState _state;
        private final PortStateV10 _stateV10;
        private final PortFeatures _supportedFeatures;
        private final PortFeaturesV10 _supportedFeaturesV10;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortStatusMessage> getImplementedInterface() {
            return PortStatusMessage.class;
        }

        private PortStatusMessageImpl(PortStatusMessageBuilder base) {
            this._advertisedFeatures = base.getAdvertisedFeatures();
            this._advertisedFeaturesV10 = base.getAdvertisedFeaturesV10();
            this._config = base.getConfig();
            this._configV10 = base.getConfigV10();
            this._currSpeed = base.getCurrSpeed();
            this._currentFeatures = base.getCurrentFeatures();
            this._currentFeaturesV10 = base.getCurrentFeaturesV10();
            this._hwAddr = base.getHwAddr();
            this._maxSpeed = base.getMaxSpeed();
            this._name = base.getName();
            this._peerFeatures = base.getPeerFeatures();
            this._peerFeaturesV10 = base.getPeerFeaturesV10();
            this._portNo = base.getPortNo();
            this._reason = base.getReason();
            this._state = base.getState();
            this._stateV10 = base.getStateV10();
            this._supportedFeatures = base.getSupportedFeatures();
            this._supportedFeaturesV10 = base.getSupportedFeaturesV10();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        @Override
        public PortFeaturesV10 getAdvertisedFeaturesV10() {
            return this._advertisedFeaturesV10;
        }

        @Override
        public PortConfig getConfig() {
            return this._config;
        }

        @Override
        public PortConfigV10 getConfigV10() {
            return this._configV10;
        }

        @Override
        public Long getCurrSpeed() {
            return this._currSpeed;
        }

        @Override
        public PortFeatures getCurrentFeatures() {
            return this._currentFeatures;
        }

        @Override
        public PortFeaturesV10 getCurrentFeaturesV10() {
            return this._currentFeaturesV10;
        }

        @Override
        public MacAddress getHwAddr() {
            return this._hwAddr;
        }

        @Override
        public Long getMaxSpeed() {
            return this._maxSpeed;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        @Override
        public PortFeaturesV10 getPeerFeaturesV10() {
            return this._peerFeaturesV10;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public PortReason getReason() {
            return this._reason;
        }

        @Override
        public PortState getState() {
            return this._state;
        }

        @Override
        public PortStateV10 getStateV10() {
            return this._stateV10;
        }

        @Override
        public PortFeatures getSupportedFeatures() {
            return this._supportedFeatures;
        }

        @Override
        public PortFeaturesV10 getSupportedFeaturesV10() {
            return this._supportedFeaturesV10;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PortStatusMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._advertisedFeatures);
            result = 31 * result + Objects.hashCode(this._advertisedFeaturesV10);
            result = 31 * result + Objects.hashCode(this._config);
            result = 31 * result + Objects.hashCode(this._configV10);
            result = 31 * result + Objects.hashCode(this._currSpeed);
            result = 31 * result + Objects.hashCode(this._currentFeatures);
            result = 31 * result + Objects.hashCode(this._currentFeaturesV10);
            result = 31 * result + Objects.hashCode(this._hwAddr);
            result = 31 * result + Objects.hashCode(this._maxSpeed);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._peerFeatures);
            result = 31 * result + Objects.hashCode(this._peerFeaturesV10);
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode((Object)this._reason);
            result = 31 * result + Objects.hashCode(this._state);
            result = 31 * result + Objects.hashCode(this._stateV10);
            result = 31 * result + Objects.hashCode(this._supportedFeatures);
            result = 31 * result + Objects.hashCode(this._supportedFeaturesV10);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortStatusMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortStatusMessage other = (PortStatusMessage)obj;
            if (!Objects.equals(this._advertisedFeatures, other.getAdvertisedFeatures())) {
                return false;
            }
            if (!Objects.equals(this._advertisedFeaturesV10, other.getAdvertisedFeaturesV10())) {
                return false;
            }
            if (!Objects.equals(this._config, other.getConfig())) {
                return false;
            }
            if (!Objects.equals(this._configV10, other.getConfigV10())) {
                return false;
            }
            if (!Objects.equals(this._currSpeed, other.getCurrSpeed())) {
                return false;
            }
            if (!Objects.equals(this._currentFeatures, other.getCurrentFeatures())) {
                return false;
            }
            if (!Objects.equals(this._currentFeaturesV10, other.getCurrentFeaturesV10())) {
                return false;
            }
            if (!Objects.equals(this._hwAddr, other.getHwAddr())) {
                return false;
            }
            if (!Objects.equals(this._maxSpeed, other.getMaxSpeed())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._peerFeatures, other.getPeerFeatures())) {
                return false;
            }
            if (!Objects.equals(this._peerFeaturesV10, other.getPeerFeaturesV10())) {
                return false;
            }
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals((Object)this._reason, (Object)other.getReason())) {
                return false;
            }
            if (!Objects.equals(this._state, other.getState())) {
                return false;
            }
            if (!Objects.equals(this._stateV10, other.getStateV10())) {
                return false;
            }
            if (!Objects.equals(this._supportedFeatures, other.getSupportedFeatures())) {
                return false;
            }
            if (!Objects.equals(this._supportedFeaturesV10, other.getSupportedFeaturesV10())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortStatusMessageImpl otherImpl = (PortStatusMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortStatusMessage>>, Augmentation<PortStatusMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PortStatusMessage [");
            boolean first = true;
            if (this._advertisedFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertisedFeatures=");
                builder.append(this._advertisedFeatures);
            }
            if (this._advertisedFeaturesV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_advertisedFeaturesV10=");
                builder.append(this._advertisedFeaturesV10);
            }
            if (this._config != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_config=");
                builder.append(this._config);
            }
            if (this._configV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configV10=");
                builder.append(this._configV10);
            }
            if (this._currSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currSpeed=");
                builder.append(this._currSpeed);
            }
            if (this._currentFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentFeatures=");
                builder.append(this._currentFeatures);
            }
            if (this._currentFeaturesV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_currentFeaturesV10=");
                builder.append(this._currentFeaturesV10);
            }
            if (this._hwAddr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hwAddr=");
                builder.append(this._hwAddr);
            }
            if (this._maxSpeed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxSpeed=");
                builder.append(this._maxSpeed);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._peerFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_peerFeatures=");
                builder.append(this._peerFeatures);
            }
            if (this._peerFeaturesV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_peerFeaturesV10=");
                builder.append(this._peerFeaturesV10);
            }
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append((Object)this._reason);
            }
            if (this._state != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_state=");
                builder.append(this._state);
            }
            if (this._stateV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateV10=");
                builder.append(this._stateV10);
            }
            if (this._supportedFeatures != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supportedFeatures=");
                builder.append(this._supportedFeatures);
            }
            if (this._supportedFeaturesV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supportedFeaturesV10=");
                builder.append(this._supportedFeaturesV10);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

