/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueuePropContainerBuilder
implements Builder<QueuePropContainer> {
    private List<QueueProperty> _queueProperty;
    Map<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>> augmentation = Collections.emptyMap();

    public QueuePropContainerBuilder() {
    }

    public QueuePropContainerBuilder(QueuePropertyHeader arg) {
        this._queueProperty = arg.getQueueProperty();
    }

    public QueuePropContainerBuilder(QueuePropContainer base) {
        AugmentationHolder casted;
        this._queueProperty = base.getQueueProperty();
        if (base instanceof QueuePropContainerImpl) {
            QueuePropContainerImpl impl = (QueuePropContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueuePropertyHeader) {
            this._queueProperty = ((QueuePropertyHeader)arg).getQueueProperty();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader] \nbut was: " + arg);
        }
    }

    public List<QueueProperty> getQueueProperty() {
        return this._queueProperty;
    }

    public <E extends Augmentation<QueuePropContainer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueuePropContainerBuilder setQueueProperty(List<QueueProperty> value) {
        this._queueProperty = value;
        return this;
    }

    public QueuePropContainerBuilder addAugmentation(Class<? extends Augmentation<QueuePropContainer>> augmentationType, Augmentation<QueuePropContainer> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueuePropContainerBuilder removeAugmentation(Class<? extends Augmentation<QueuePropContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QueuePropContainer build() {
        return new QueuePropContainerImpl(this);
    }

    private static final class QueuePropContainerImpl
    implements QueuePropContainer {
        private final List<QueueProperty> _queueProperty;
        private Map<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<QueuePropContainer> getImplementedInterface() {
            return QueuePropContainer.class;
        }

        private QueuePropContainerImpl(QueuePropContainerBuilder base) {
            this._queueProperty = base.getQueueProperty();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>>(base.augmentation);
                }
            }
        }

        @Override
        public List<QueueProperty> getQueueProperty() {
            return this._queueProperty;
        }

        public <E extends Augmentation<QueuePropContainer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._queueProperty);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QueuePropContainer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            QueuePropContainer other = (QueuePropContainer)obj;
            if (!Objects.equals(this._queueProperty, other.getQueueProperty())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QueuePropContainerImpl otherImpl = (QueuePropContainerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<QueuePropContainer>>, Augmentation<QueuePropContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("QueuePropContainer [");
            boolean first = true;
            if (this._queueProperty != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueProperty=");
                builder.append(this._queueProperty);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

