/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoleRequestInputBuilder
implements Builder<RoleRequestInput> {
    private BigInteger _generationId;
    private ControllerRole _role;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKGENERATIONIDRANGE_RANGES;

    public RoleRequestInputBuilder() {
    }

    public RoleRequestInputBuilder(RoleRequest arg) {
        this._role = arg.getRole();
        this._generationId = arg.getGenerationId();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public RoleRequestInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public RoleRequestInputBuilder(RoleRequestInput base) {
        AugmentationHolder casted;
        this._generationId = base.getGenerationId();
        this._role = base.getRole();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof RoleRequestInputImpl) {
            RoleRequestInputImpl impl = (RoleRequestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RoleRequest) {
            this._role = ((RoleRequest)arg).getRole();
            this._generationId = ((RoleRequest)arg).getGenerationId();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequest, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public BigInteger getGenerationId() {
        return this._generationId;
    }

    public ControllerRole getRole() {
        return this._role;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<RoleRequestInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkGenerationIdRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKGENERATIONIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKGENERATIONIDRANGE_RANGES)));
    }

    public RoleRequestInputBuilder setGenerationId(BigInteger value) {
        if (value != null) {
            RoleRequestInputBuilder.checkGenerationIdRange(value);
        }
        this._generationId = value;
        return this;
    }

    public RoleRequestInputBuilder setRole(ControllerRole value) {
        this._role = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public RoleRequestInputBuilder setVersion(Short value) {
        if (value != null) {
            RoleRequestInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public RoleRequestInputBuilder setXid(Long value) {
        if (value != null) {
            RoleRequestInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public RoleRequestInputBuilder addAugmentation(Class<? extends Augmentation<RoleRequestInput>> augmentationType, Augmentation<RoleRequestInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RoleRequestInputBuilder removeAugmentation(Class<? extends Augmentation<RoleRequestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoleRequestInput build() {
        return new RoleRequestInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKGENERATIONIDRANGE_RANGES = a;
    }

    private static final class RoleRequestInputImpl
    implements RoleRequestInput {
        private final BigInteger _generationId;
        private final ControllerRole _role;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RoleRequestInput> getImplementedInterface() {
            return RoleRequestInput.class;
        }

        private RoleRequestInputImpl(RoleRequestInputBuilder base) {
            this._generationId = base.getGenerationId();
            this._role = base.getRole();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getGenerationId() {
            return this._generationId;
        }

        @Override
        public ControllerRole getRole() {
            return this._role;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<RoleRequestInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._generationId);
            result = 31 * result + Objects.hashCode((Object)this._role);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RoleRequestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RoleRequestInput other = (RoleRequestInput)obj;
            if (!Objects.equals(this._generationId, other.getGenerationId())) {
                return false;
            }
            if (!Objects.equals((Object)this._role, (Object)other.getRole())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RoleRequestInputImpl otherImpl = (RoleRequestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RoleRequestInput [");
            boolean first = true;
            if (this._generationId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_generationId=");
                builder.append(this._generationId);
            }
            if (this._role != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_role=");
                builder.append((Object)this._role);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

