/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetConfigInputBuilder
implements Builder<SetConfigInput> {
    private SwitchConfigFlag _flags;
    private Integer _missSendLen;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> augmentation = Collections.emptyMap();

    public SetConfigInputBuilder() {
    }

    public SetConfigInputBuilder(SetConfig arg) {
        this._flags = arg.getFlags();
        this._missSendLen = arg.getMissSendLen();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public SetConfigInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public SetConfigInputBuilder(SetConfigInput base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._missSendLen = base.getMissSendLen();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof SetConfigInputImpl) {
            SetConfigInputImpl impl = (SetConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SetConfig) {
            this._flags = ((SetConfig)arg).getFlags();
            this._missSendLen = ((SetConfig)arg).getMissSendLen();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfig, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public SwitchConfigFlag getFlags() {
        return this._flags;
    }

    public Integer getMissSendLen() {
        return this._missSendLen;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<SetConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetConfigInputBuilder setFlags(SwitchConfigFlag value) {
        this._flags = value;
        return this;
    }

    private static void checkMissSendLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SetConfigInputBuilder setMissSendLen(Integer value) {
        if (value != null) {
            SetConfigInputBuilder.checkMissSendLenRange(value);
        }
        this._missSendLen = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public SetConfigInputBuilder setVersion(Short value) {
        if (value != null) {
            SetConfigInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SetConfigInputBuilder setXid(Long value) {
        if (value != null) {
            SetConfigInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public SetConfigInputBuilder addAugmentation(Class<? extends Augmentation<SetConfigInput>> augmentationType, Augmentation<SetConfigInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetConfigInputBuilder removeAugmentation(Class<? extends Augmentation<SetConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetConfigInput build() {
        return new SetConfigInputImpl(this);
    }

    private static final class SetConfigInputImpl
    implements SetConfigInput {
        private final SwitchConfigFlag _flags;
        private final Integer _missSendLen;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetConfigInput> getImplementedInterface() {
            return SetConfigInput.class;
        }

        private SetConfigInputImpl(SetConfigInputBuilder base) {
            this._flags = base.getFlags();
            this._missSendLen = base.getMissSendLen();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(base.augmentation);
                }
            }
        }

        @Override
        public SwitchConfigFlag getFlags() {
            return this._flags;
        }

        @Override
        public Integer getMissSendLen() {
            return this._missSendLen;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<SetConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._flags);
            result = 31 * result + Objects.hashCode(this._missSendLen);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetConfigInput other = (SetConfigInput)obj;
            if (!Objects.equals((Object)this._flags, (Object)other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._missSendLen, other.getMissSendLen())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetConfigInputImpl otherImpl = (SetConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SetConfigInput [");
            boolean first = true;
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append((Object)this._flags);
            }
            if (this._missSendLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_missSendLen=");
                builder.append(this._missSendLen);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

