/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableModInputBuilder
implements Builder<TableModInput> {
    private TableConfig _config;
    private TableId _tableId;
    private Short _version;
    private Long _xid;
    Map<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>> augmentation = Collections.emptyMap();

    public TableModInputBuilder() {
    }

    public TableModInputBuilder(TableMod arg) {
        this._tableId = arg.getTableId();
        this._config = arg.getConfig();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public TableModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public TableModInputBuilder(TableModInput base) {
        AugmentationHolder casted;
        this._config = base.getConfig();
        this._tableId = base.getTableId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof TableModInputImpl) {
            TableModInputImpl impl = (TableModInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof TableMod) {
            this._tableId = ((TableMod)arg).getTableId();
            this._config = ((TableMod)arg).getConfig();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableMod] \nbut was: " + arg);
        }
    }

    public TableConfig getConfig() {
        return this._config;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<TableModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableModInputBuilder setConfig(TableConfig value) {
        this._config = value;
        return this;
    }

    public TableModInputBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableModInputBuilder setVersion(Short value) {
        if (value != null) {
            TableModInputBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TableModInputBuilder setXid(Long value) {
        if (value != null) {
            TableModInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public TableModInputBuilder addAugmentation(Class<? extends Augmentation<TableModInput>> augmentationType, Augmentation<TableModInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableModInputBuilder removeAugmentation(Class<? extends Augmentation<TableModInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableModInput build() {
        return new TableModInputImpl(this);
    }

    private static final class TableModInputImpl
    implements TableModInput {
        private final TableConfig _config;
        private final TableId _tableId;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableModInput> getImplementedInterface() {
            return TableModInput.class;
        }

        private TableModInputImpl(TableModInputBuilder base) {
            this._config = base.getConfig();
            this._tableId = base.getTableId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>>(base.augmentation);
                }
            }
        }

        @Override
        public TableConfig getConfig() {
            return this._config;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<TableModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._config);
            result = 31 * result + Objects.hashCode(this._tableId);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableModInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableModInput other = (TableModInput)obj;
            if (!Objects.equals(this._config, other.getConfig())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableModInputImpl otherImpl = (TableModInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableModInput>>, Augmentation<TableModInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TableModInput [");
            boolean first = true;
            if (this._config != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_config=");
                builder.append(this._config);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._xid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xid=");
                builder.append(this._xid);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

