/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketInMaskBuilder
implements Builder<PacketInMask> {
    private List<PacketInReason> _mask;
    Map<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> augmentation = Collections.emptyMap();

    public PacketInMaskBuilder() {
    }

    public PacketInMaskBuilder(PacketInMask base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        if (base instanceof PacketInMaskImpl) {
            PacketInMaskImpl impl = (PacketInMaskImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>(casted.augmentations());
        }
    }

    public List<PacketInReason> getMask() {
        return this._mask;
    }

    public <E extends Augmentation<PacketInMask>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketInMaskBuilder setMask(List<PacketInReason> value) {
        this._mask = value;
        return this;
    }

    public PacketInMaskBuilder addAugmentation(Class<? extends Augmentation<PacketInMask>> augmentationType, Augmentation<PacketInMask> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketInMaskBuilder removeAugmentation(Class<? extends Augmentation<PacketInMask>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketInMask build() {
        return new PacketInMaskImpl(this);
    }

    private static final class PacketInMaskImpl
    implements PacketInMask {
        private final List<PacketInReason> _mask;
        private Map<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketInMask> getImplementedInterface() {
            return PacketInMask.class;
        }

        private PacketInMaskImpl(PacketInMaskBuilder base) {
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>(base.augmentation);
                }
            }
        }

        @Override
        public List<PacketInReason> getMask() {
            return this._mask;
        }

        public <E extends Augmentation<PacketInMask>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketInMask.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketInMask other = (PacketInMask)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketInMaskImpl otherImpl = (PacketInMaskImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PacketInMask [");
            boolean first = true;
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(this._mask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

