/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BucketsListBuilder
implements Builder<BucketsList> {
    private List<Action> _action;
    private Long _watchGroup;
    private PortNumber _watchPort;
    private Integer _weight;
    Map<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> augmentation = Collections.emptyMap();

    public BucketsListBuilder() {
    }

    public BucketsListBuilder(BucketGrouping arg) {
        this._weight = arg.getWeight();
        this._watchPort = arg.getWatchPort();
        this._watchGroup = arg.getWatchGroup();
        this._action = arg.getAction();
    }

    public BucketsListBuilder(ActionsGrouping arg) {
        this._action = arg.getAction();
    }

    public BucketsListBuilder(BucketsList base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._watchGroup = base.getWatchGroup();
        this._watchPort = base.getWatchPort();
        this._weight = base.getWeight();
        if (base instanceof BucketsListImpl) {
            BucketsListImpl impl = (BucketsListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BucketGrouping) {
            this._weight = ((BucketGrouping)arg).getWeight();
            this._watchPort = ((BucketGrouping)arg).getWatchPort();
            this._watchGroup = ((BucketGrouping)arg).getWatchGroup();
            isValidArg = true;
        }
        if (arg instanceof ActionsGrouping) {
            this._action = ((ActionsGrouping)arg).getAction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public Long getWatchGroup() {
        return this._watchGroup;
    }

    public PortNumber getWatchPort() {
        return this._watchPort;
    }

    public Integer getWeight() {
        return this._weight;
    }

    public <E extends Augmentation<BucketsList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketsListBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkWatchGroupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public BucketsListBuilder setWatchGroup(Long value) {
        if (value != null) {
            BucketsListBuilder.checkWatchGroupRange(value);
        }
        this._watchGroup = value;
        return this;
    }

    public BucketsListBuilder setWatchPort(PortNumber value) {
        this._watchPort = value;
        return this;
    }

    private static void checkWeightRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BucketsListBuilder setWeight(Integer value) {
        if (value != null) {
            BucketsListBuilder.checkWeightRange(value);
        }
        this._weight = value;
        return this;
    }

    public BucketsListBuilder addAugmentation(Class<? extends Augmentation<BucketsList>> augmentationType, Augmentation<BucketsList> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BucketsListBuilder removeAugmentation(Class<? extends Augmentation<BucketsList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BucketsList build() {
        return new BucketsListImpl(this);
    }

    private static final class BucketsListImpl
    implements BucketsList {
        private final List<Action> _action;
        private final Long _watchGroup;
        private final PortNumber _watchPort;
        private final Integer _weight;
        private Map<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BucketsList> getImplementedInterface() {
            return BucketsList.class;
        }

        private BucketsListImpl(BucketsListBuilder base) {
            this._action = base.getAction();
            this._watchGroup = base.getWatchGroup();
            this._watchPort = base.getWatchPort();
            this._weight = base.getWeight();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public Long getWatchGroup() {
            return this._watchGroup;
        }

        @Override
        public PortNumber getWatchPort() {
            return this._watchPort;
        }

        @Override
        public Integer getWeight() {
            return this._weight;
        }

        public <E extends Augmentation<BucketsList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._watchGroup);
            result = 31 * result + Objects.hashCode(this._watchPort);
            result = 31 * result + Objects.hashCode(this._weight);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BucketsList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BucketsList other = (BucketsList)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._watchGroup, other.getWatchGroup())) {
                return false;
            }
            if (!Objects.equals(this._watchPort, other.getWatchPort())) {
                return false;
            }
            if (!Objects.equals(this._weight, other.getWeight())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BucketsListImpl otherImpl = (BucketsListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("BucketsList [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._watchGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_watchGroup=");
                builder.append(this._watchGroup);
            }
            if (this._watchPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_watchPort=");
                builder.append(this._watchPort);
            }
            if (this._weight != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_weight=");
                builder.append(this._weight);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

