/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHelloElementHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ElementsBuilder
implements Builder<Elements> {
    private HelloElementType _type;
    private List<Boolean> _versionBitmap;
    Map<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> augmentation = Collections.emptyMap();

    public ElementsBuilder() {
    }

    public ElementsBuilder(OfHelloElementHeader arg) {
        this._type = arg.getType();
    }

    public ElementsBuilder(Elements base) {
        AugmentationHolder casted;
        this._type = base.getType();
        this._versionBitmap = base.getVersionBitmap();
        if (base instanceof ElementsImpl) {
            ElementsImpl impl = (ElementsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHelloElementHeader) {
            this._type = ((OfHelloElementHeader)arg).getType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHelloElementHeader] \nbut was: " + arg);
        }
    }

    public HelloElementType getType() {
        return this._type;
    }

    public List<Boolean> getVersionBitmap() {
        return this._versionBitmap;
    }

    public <E extends Augmentation<Elements>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ElementsBuilder setType(HelloElementType value) {
        this._type = value;
        return this;
    }

    public ElementsBuilder setVersionBitmap(List<Boolean> value) {
        this._versionBitmap = value;
        return this;
    }

    public ElementsBuilder addAugmentation(Class<? extends Augmentation<Elements>> augmentationType, Augmentation<Elements> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ElementsBuilder removeAugmentation(Class<? extends Augmentation<Elements>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Elements build() {
        return new ElementsImpl(this);
    }

    private static final class ElementsImpl
    implements Elements {
        private final HelloElementType _type;
        private final List<Boolean> _versionBitmap;
        private Map<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Elements> getImplementedInterface() {
            return Elements.class;
        }

        private ElementsImpl(ElementsBuilder base) {
            this._type = base.getType();
            this._versionBitmap = base.getVersionBitmap();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>(base.augmentation);
                }
            }
        }

        @Override
        public HelloElementType getType() {
            return this._type;
        }

        @Override
        public List<Boolean> getVersionBitmap() {
            return this._versionBitmap;
        }

        public <E extends Augmentation<Elements>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._type);
            result = 31 * result + Objects.hashCode(this._versionBitmap);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Elements.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Elements other = (Elements)obj;
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (!Objects.equals(this._versionBitmap, other.getVersionBitmap())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ElementsImpl otherImpl = (ElementsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Elements [");
            boolean first = true;
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (this._versionBitmap != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_versionBitmap=");
                builder.append(this._versionBitmap);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

