/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterBandCommons;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDrop;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBandDropBuilder
implements Builder<MeterBandDrop> {
    private Long _burstSize;
    private Long _rate;
    private MeterBandType _type;
    Map<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>> augmentation = Collections.emptyMap();

    public MeterBandDropBuilder() {
    }

    public MeterBandDropBuilder(MeterBandCommons arg) {
        this._type = arg.getType();
        this._rate = arg.getRate();
        this._burstSize = arg.getBurstSize();
    }

    public MeterBandDropBuilder(MeterBandDrop base) {
        AugmentationHolder casted;
        this._burstSize = base.getBurstSize();
        this._rate = base.getRate();
        this._type = base.getType();
        if (base instanceof MeterBandDropImpl) {
            MeterBandDropImpl impl = (MeterBandDropImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MeterBandCommons) {
            this._type = ((MeterBandCommons)arg).getType();
            this._rate = ((MeterBandCommons)arg).getRate();
            this._burstSize = ((MeterBandCommons)arg).getBurstSize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterBandCommons] \nbut was: " + arg);
        }
    }

    public Long getBurstSize() {
        return this._burstSize;
    }

    public Long getRate() {
        return this._rate;
    }

    public MeterBandType getType() {
        return this._type;
    }

    public <E extends Augmentation<MeterBandDrop>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBurstSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterBandDropBuilder setBurstSize(Long value) {
        if (value != null) {
            MeterBandDropBuilder.checkBurstSizeRange(value);
        }
        this._burstSize = value;
        return this;
    }

    private static void checkRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterBandDropBuilder setRate(Long value) {
        if (value != null) {
            MeterBandDropBuilder.checkRateRange(value);
        }
        this._rate = value;
        return this;
    }

    public MeterBandDropBuilder setType(MeterBandType value) {
        this._type = value;
        return this;
    }

    public MeterBandDropBuilder addAugmentation(Class<? extends Augmentation<MeterBandDrop>> augmentationType, Augmentation<MeterBandDrop> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBandDropBuilder removeAugmentation(Class<? extends Augmentation<MeterBandDrop>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MeterBandDrop build() {
        return new MeterBandDropImpl(this);
    }

    private static final class MeterBandDropImpl
    implements MeterBandDrop {
        private final Long _burstSize;
        private final Long _rate;
        private final MeterBandType _type;
        private Map<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MeterBandDrop> getImplementedInterface() {
            return MeterBandDrop.class;
        }

        private MeterBandDropImpl(MeterBandDropBuilder base) {
            this._burstSize = base.getBurstSize();
            this._rate = base.getRate();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getBurstSize() {
            return this._burstSize;
        }

        @Override
        public Long getRate() {
            return this._rate;
        }

        @Override
        public MeterBandType getType() {
            return this._type;
        }

        public <E extends Augmentation<MeterBandDrop>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._burstSize);
            result = 31 * result + Objects.hashCode(this._rate);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MeterBandDrop.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MeterBandDrop other = (MeterBandDrop)obj;
            if (!Objects.equals(this._burstSize, other.getBurstSize())) {
                return false;
            }
            if (!Objects.equals(this._rate, other.getRate())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterBandDropImpl otherImpl = (MeterBandDropImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MeterBandDrop>>, Augmentation<MeterBandDrop>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MeterBandDrop [");
            boolean first = true;
            if (this._burstSize != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_burstSize=");
                builder.append(this._burstSize);
            }
            if (this._rate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rate=");
                builder.append(this._rate);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

