/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartReplyAggregateBuilder
implements Builder<MultipartReplyAggregate> {
    private BigInteger _byteCount;
    private Long _flowCount;
    private BigInteger _packetCount;
    Map<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public MultipartReplyAggregateBuilder() {
    }

    public MultipartReplyAggregateBuilder(MultipartReplyAggregate base) {
        AugmentationHolder casted;
        this._byteCount = base.getByteCount();
        this._flowCount = base.getFlowCount();
        this._packetCount = base.getPacketCount();
        if (base instanceof MultipartReplyAggregateImpl) {
            MultipartReplyAggregateImpl impl = (MultipartReplyAggregateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>>(casted.augmentations());
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public Long getFlowCount() {
        return this._flowCount;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public <E extends Augmentation<MultipartReplyAggregate>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public MultipartReplyAggregateBuilder setByteCount(BigInteger value) {
        if (value != null) {
            MultipartReplyAggregateBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    private static void checkFlowCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartReplyAggregateBuilder setFlowCount(Long value) {
        if (value != null) {
            MultipartReplyAggregateBuilder.checkFlowCountRange(value);
        }
        this._flowCount = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public MultipartReplyAggregateBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            MultipartReplyAggregateBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    public MultipartReplyAggregateBuilder addAugmentation(Class<? extends Augmentation<MultipartReplyAggregate>> augmentationType, Augmentation<MultipartReplyAggregate> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartReplyAggregateBuilder removeAugmentation(Class<? extends Augmentation<MultipartReplyAggregate>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartReplyAggregate build() {
        return new MultipartReplyAggregateImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class MultipartReplyAggregateImpl
    implements MultipartReplyAggregate {
        private final BigInteger _byteCount;
        private final Long _flowCount;
        private final BigInteger _packetCount;
        private Map<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartReplyAggregate> getImplementedInterface() {
            return MultipartReplyAggregate.class;
        }

        private MultipartReplyAggregateImpl(MultipartReplyAggregateBuilder base) {
            this._byteCount = base.getByteCount();
            this._flowCount = base.getFlowCount();
            this._packetCount = base.getPacketCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public Long getFlowCount() {
            return this._flowCount;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        public <E extends Augmentation<MultipartReplyAggregate>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._flowCount);
            result = 31 * result + Objects.hashCode(this._packetCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartReplyAggregate.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartReplyAggregate other = (MultipartReplyAggregate)obj;
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._flowCount, other.getFlowCount())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartReplyAggregateImpl otherImpl = (MultipartReplyAggregateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartReplyAggregate>>, Augmentation<MultipartReplyAggregate>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartReplyAggregate [");
            boolean first = true;
            if (this._byteCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteCount=");
                builder.append(this._byteCount);
            }
            if (this._flowCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowCount=");
                builder.append(this._flowCount);
            }
            if (this._packetCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetCount=");
                builder.append(this._packetCount);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

