/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowStatsBuilder
implements Builder<FlowStats> {
    private List<Action> _action;
    private BigInteger _byteCount;
    private BigInteger _cookie;
    private Long _durationNsec;
    private Long _durationSec;
    private FlowModFlags _flags;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private List<Instruction> _instruction;
    private Match _match;
    private MatchV10 _matchV10;
    private BigInteger _packetCount;
    private Integer _priority;
    private Short _tableId;
    Map<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public FlowStatsBuilder() {
    }

    public FlowStatsBuilder(InstructionsGrouping arg) {
        this._instruction = arg.getInstruction();
    }

    public FlowStatsBuilder(ActionsGrouping arg) {
        this._action = arg.getAction();
    }

    public FlowStatsBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public FlowStatsBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowStatsBuilder(FlowStats base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._byteCount = base.getByteCount();
        this._cookie = base.getCookie();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._flags = base.getFlags();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._instruction = base.getInstruction();
        this._match = base.getMatch();
        this._matchV10 = base.getMatchV10();
        this._packetCount = base.getPacketCount();
        this._priority = base.getPriority();
        this._tableId = base.getTableId();
        if (base instanceof FlowStatsImpl) {
            FlowStatsImpl impl = (FlowStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ActionsGrouping) {
            this._action = ((ActionsGrouping)arg).getAction();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof InstructionsGrouping) {
            this._instruction = ((InstructionsGrouping)arg).getInstruction();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public FlowModFlags getFlags() {
        return this._flags;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public List<Instruction> getInstruction() {
        return this._instruction;
    }

    public Match getMatch() {
        return this._match;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<FlowStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowStatsBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public FlowStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            FlowStatsBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public FlowStatsBuilder setCookie(BigInteger value) {
        if (value != null) {
            FlowStatsBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            FlowStatsBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FlowStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            FlowStatsBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    public FlowStatsBuilder setFlags(FlowModFlags value) {
        this._flags = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowStatsBuilder setHardTimeout(Integer value) {
        if (value != null) {
            FlowStatsBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowStatsBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            FlowStatsBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowStatsBuilder setInstruction(List<Instruction> value) {
        this._instruction = value;
        return this;
    }

    public FlowStatsBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowStatsBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public FlowStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            FlowStatsBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlowStatsBuilder setPriority(Integer value) {
        if (value != null) {
            FlowStatsBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public FlowStatsBuilder setTableId(Short value) {
        if (value != null) {
            FlowStatsBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public FlowStatsBuilder addAugmentation(Class<? extends Augmentation<FlowStats>> augmentationType, Augmentation<FlowStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowStatsBuilder removeAugmentation(Class<? extends Augmentation<FlowStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowStats build() {
        return new FlowStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class FlowStatsImpl
    implements FlowStats {
        private final List<Action> _action;
        private final BigInteger _byteCount;
        private final BigInteger _cookie;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final FlowModFlags _flags;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final List<Instruction> _instruction;
        private final Match _match;
        private final MatchV10 _matchV10;
        private final BigInteger _packetCount;
        private final Integer _priority;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowStats> getImplementedInterface() {
            return FlowStats.class;
        }

        private FlowStatsImpl(FlowStatsBuilder base) {
            this._action = base.getAction();
            this._byteCount = base.getByteCount();
            this._cookie = base.getCookie();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._flags = base.getFlags();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._instruction = base.getInstruction();
            this._match = base.getMatch();
            this._matchV10 = base.getMatchV10();
            this._packetCount = base.getPacketCount();
            this._priority = base.getPriority();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public FlowModFlags getFlags() {
            return this._flags;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public List<Instruction> getInstruction() {
            return this._instruction;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<FlowStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._hardTimeout);
            result = 31 * result + Objects.hashCode(this._idleTimeout);
            result = 31 * result + Objects.hashCode(this._instruction);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._matchV10);
            result = 31 * result + Objects.hashCode(this._packetCount);
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowStats other = (FlowStats)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._hardTimeout, other.getHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._idleTimeout, other.getIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._instruction, other.getInstruction())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._matchV10, other.getMatchV10())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowStatsImpl otherImpl = (FlowStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FlowStats [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append(this._action);
            }
            if (this._byteCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteCount=");
                builder.append(this._byteCount);
            }
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._hardTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
            }
            if (this._idleTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
            }
            if (this._instruction != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instruction=");
                builder.append(this._instruction);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._matchV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchV10=");
                builder.append(this._matchV10);
            }
            if (this._packetCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetCount=");
                builder.append(this._packetCount);
            }
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

