/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupStatsBuilder
implements Builder<GroupStats> {
    private List<BucketStats> _bucketStats;
    private BigInteger _byteCount;
    private Long _durationNsec;
    private Long _durationSec;
    private GroupId _groupId;
    private BigInteger _packetCount;
    private Long _refCount;
    Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public GroupStatsBuilder() {
    }

    public GroupStatsBuilder(GroupStats base) {
        AugmentationHolder casted;
        this._bucketStats = base.getBucketStats();
        this._byteCount = base.getByteCount();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._groupId = base.getGroupId();
        this._packetCount = base.getPacketCount();
        this._refCount = base.getRefCount();
        if (base instanceof GroupStatsImpl) {
            GroupStatsImpl impl = (GroupStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>(casted.augmentations());
        }
    }

    public List<BucketStats> getBucketStats() {
        return this._bucketStats;
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Long getRefCount() {
        return this._refCount;
    }

    public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupStatsBuilder setBucketStats(List<BucketStats> value) {
        this._bucketStats = value;
        return this;
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public GroupStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            GroupStatsBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GroupStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            GroupStatsBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GroupStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            GroupStatsBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    public GroupStatsBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public GroupStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            GroupStatsBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    private static void checkRefCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GroupStatsBuilder setRefCount(Long value) {
        if (value != null) {
            GroupStatsBuilder.checkRefCountRange(value);
        }
        this._refCount = value;
        return this;
    }

    public GroupStatsBuilder addAugmentation(Class<? extends Augmentation<GroupStats>> augmentationType, Augmentation<GroupStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupStatsBuilder removeAugmentation(Class<? extends Augmentation<GroupStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GroupStats build() {
        return new GroupStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class GroupStatsImpl
    implements GroupStats {
        private final List<BucketStats> _bucketStats;
        private final BigInteger _byteCount;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final GroupId _groupId;
        private final BigInteger _packetCount;
        private final Long _refCount;
        private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GroupStats> getImplementedInterface() {
            return GroupStats.class;
        }

        private GroupStatsImpl(GroupStatsBuilder base) {
            this._bucketStats = base.getBucketStats();
            this._byteCount = base.getByteCount();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._groupId = base.getGroupId();
            this._packetCount = base.getPacketCount();
            this._refCount = base.getRefCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BucketStats> getBucketStats() {
            return this._bucketStats;
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Long getRefCount() {
            return this._refCount;
        }

        public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bucketStats);
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode(this._packetCount);
            result = 31 * result + Objects.hashCode(this._refCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GroupStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GroupStats other = (GroupStats)obj;
            if (!Objects.equals(this._bucketStats, other.getBucketStats())) {
                return false;
            }
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (!Objects.equals(this._refCount, other.getRefCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GroupStatsImpl otherImpl = (GroupStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GroupStats [");
            boolean first = true;
            if (this._bucketStats != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bucketStats=");
                builder.append(this._bucketStats);
            }
            if (this._byteCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteCount=");
                builder.append(this._byteCount);
            }
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._groupId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupId=");
                builder.append(this._groupId);
            }
            if (this._packetCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetCount=");
                builder.append(this._packetCount);
            }
            if (this._refCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_refCount=");
                builder.append(this._refCount);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

