/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BucketStatsBuilder
implements Builder<BucketStats> {
    private BigInteger _byteCount;
    private BigInteger _packetCount;
    Map<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public BucketStatsBuilder() {
    }

    public BucketStatsBuilder(BucketStats base) {
        AugmentationHolder casted;
        this._byteCount = base.getByteCount();
        this._packetCount = base.getPacketCount();
        if (base instanceof BucketStatsImpl) {
            BucketStatsImpl impl = (BucketStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>(casted.augmentations());
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public <E extends Augmentation<BucketStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public BucketStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            BucketStatsBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public BucketStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            BucketStatsBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    public BucketStatsBuilder addAugmentation(Class<? extends Augmentation<BucketStats>> augmentationType, Augmentation<BucketStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BucketStatsBuilder removeAugmentation(Class<? extends Augmentation<BucketStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BucketStats build() {
        return new BucketStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class BucketStatsImpl
    implements BucketStats {
        private final BigInteger _byteCount;
        private final BigInteger _packetCount;
        private Map<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BucketStats> getImplementedInterface() {
            return BucketStats.class;
        }

        private BucketStatsImpl(BucketStatsBuilder base) {
            this._byteCount = base.getByteCount();
            this._packetCount = base.getPacketCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        public <E extends Augmentation<BucketStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._packetCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BucketStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BucketStats other = (BucketStats)obj;
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BucketStatsImpl otherImpl = (BucketStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("BucketStats [");
            boolean first = true;
            if (this._byteCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteCount=");
                builder.append(this._byteCount);
            }
            if (this._packetCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetCount=");
                builder.append(this._packetCount);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

