/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupDescBuilder
implements Builder<GroupDesc> {
    private List<BucketsList> _bucketsList;
    private GroupId _groupId;
    private GroupType _type;
    Map<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>> augmentation = Collections.emptyMap();

    public GroupDescBuilder() {
    }

    public GroupDescBuilder(BucketsGrouping arg) {
        this._bucketsList = arg.getBucketsList();
    }

    public GroupDescBuilder(GroupDesc base) {
        AugmentationHolder casted;
        this._bucketsList = base.getBucketsList();
        this._groupId = base.getGroupId();
        this._type = base.getType();
        if (base instanceof GroupDescImpl) {
            GroupDescImpl impl = (GroupDescImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BucketsGrouping) {
            this._bucketsList = ((BucketsGrouping)arg).getBucketsList();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BucketsGrouping] \nbut was: " + arg);
        }
    }

    public List<BucketsList> getBucketsList() {
        return this._bucketsList;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public GroupType getType() {
        return this._type;
    }

    public <E extends Augmentation<GroupDesc>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupDescBuilder setBucketsList(List<BucketsList> value) {
        this._bucketsList = value;
        return this;
    }

    public GroupDescBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupDescBuilder setType(GroupType value) {
        this._type = value;
        return this;
    }

    public GroupDescBuilder addAugmentation(Class<? extends Augmentation<GroupDesc>> augmentationType, Augmentation<GroupDesc> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupDescBuilder removeAugmentation(Class<? extends Augmentation<GroupDesc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GroupDesc build() {
        return new GroupDescImpl(this);
    }

    private static final class GroupDescImpl
    implements GroupDesc {
        private final List<BucketsList> _bucketsList;
        private final GroupId _groupId;
        private final GroupType _type;
        private Map<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GroupDesc> getImplementedInterface() {
            return GroupDesc.class;
        }

        private GroupDescImpl(GroupDescBuilder base) {
            this._bucketsList = base.getBucketsList();
            this._groupId = base.getGroupId();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BucketsList> getBucketsList() {
            return this._bucketsList;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public GroupType getType() {
            return this._type;
        }

        public <E extends Augmentation<GroupDesc>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bucketsList);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GroupDesc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GroupDesc other = (GroupDesc)obj;
            if (!Objects.equals(this._bucketsList, other.getBucketsList())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GroupDescImpl otherImpl = (GroupDescImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GroupDesc>>, Augmentation<GroupDesc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GroupDesc [");
            boolean first = true;
            if (this._bucketsList != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bucketsList=");
                builder.append(this._bucketsList);
            }
            if (this._groupId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupId=");
                builder.append(this._groupId);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

