/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterStatsBuilder
implements Builder<MeterStats> {
    private BigInteger _byteInCount;
    private Long _durationNsec;
    private Long _durationSec;
    private Long _flowCount;
    private List<MeterBandStats> _meterBandStats;
    private MeterId _meterId;
    private BigInteger _packetInCount;
    Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTEINCOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETINCOUNTRANGE_RANGES;

    public MeterStatsBuilder() {
    }

    public MeterStatsBuilder(MeterStats base) {
        AugmentationHolder casted;
        this._byteInCount = base.getByteInCount();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._flowCount = base.getFlowCount();
        this._meterBandStats = base.getMeterBandStats();
        this._meterId = base.getMeterId();
        this._packetInCount = base.getPacketInCount();
        if (base instanceof MeterStatsImpl) {
            MeterStatsImpl impl = (MeterStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>(casted.augmentations());
        }
    }

    public BigInteger getByteInCount() {
        return this._byteInCount;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getFlowCount() {
        return this._flowCount;
    }

    public List<MeterBandStats> getMeterBandStats() {
        return this._meterBandStats;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public BigInteger getPacketInCount() {
        return this._packetInCount;
    }

    public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteInCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTEINCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTEINCOUNTRANGE_RANGES)));
    }

    public MeterStatsBuilder setByteInCount(BigInteger value) {
        if (value != null) {
            MeterStatsBuilder.checkByteInCountRange(value);
        }
        this._byteInCount = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            MeterStatsBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            MeterStatsBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    private static void checkFlowCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterStatsBuilder setFlowCount(Long value) {
        if (value != null) {
            MeterStatsBuilder.checkFlowCountRange(value);
        }
        this._flowCount = value;
        return this;
    }

    public MeterStatsBuilder setMeterBandStats(List<MeterBandStats> value) {
        this._meterBandStats = value;
        return this;
    }

    public MeterStatsBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    private static void checkPacketInCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETINCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETINCOUNTRANGE_RANGES)));
    }

    public MeterStatsBuilder setPacketInCount(BigInteger value) {
        if (value != null) {
            MeterStatsBuilder.checkPacketInCountRange(value);
        }
        this._packetInCount = value;
        return this;
    }

    public MeterStatsBuilder addAugmentation(Class<? extends Augmentation<MeterStats>> augmentationType, Augmentation<MeterStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterStatsBuilder removeAugmentation(Class<? extends Augmentation<MeterStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MeterStats build() {
        return new MeterStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTEINCOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETINCOUNTRANGE_RANGES = a;
    }

    private static final class MeterStatsImpl
    implements MeterStats {
        private final BigInteger _byteInCount;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _flowCount;
        private final List<MeterBandStats> _meterBandStats;
        private final MeterId _meterId;
        private final BigInteger _packetInCount;
        private Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MeterStats> getImplementedInterface() {
            return MeterStats.class;
        }

        private MeterStatsImpl(MeterStatsBuilder base) {
            this._byteInCount = base.getByteInCount();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._flowCount = base.getFlowCount();
            this._meterBandStats = base.getMeterBandStats();
            this._meterId = base.getMeterId();
            this._packetInCount = base.getPacketInCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getByteInCount() {
            return this._byteInCount;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getFlowCount() {
            return this._flowCount;
        }

        @Override
        public List<MeterBandStats> getMeterBandStats() {
            return this._meterBandStats;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        @Override
        public BigInteger getPacketInCount() {
            return this._packetInCount;
        }

        public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteInCount);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._flowCount);
            result = 31 * result + Objects.hashCode(this._meterBandStats);
            result = 31 * result + Objects.hashCode(this._meterId);
            result = 31 * result + Objects.hashCode(this._packetInCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MeterStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MeterStats other = (MeterStats)obj;
            if (!Objects.equals(this._byteInCount, other.getByteInCount())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._flowCount, other.getFlowCount())) {
                return false;
            }
            if (!Objects.equals(this._meterBandStats, other.getMeterBandStats())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (!Objects.equals(this._packetInCount, other.getPacketInCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterStatsImpl otherImpl = (MeterStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MeterStats [");
            boolean first = true;
            if (this._byteInCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteInCount=");
                builder.append(this._byteInCount);
            }
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._flowCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowCount=");
                builder.append(this._flowCount);
            }
            if (this._meterBandStats != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterBandStats=");
                builder.append(this._meterBandStats);
            }
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (this._packetInCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetInCount=");
                builder.append(this._packetInCount);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

