/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBandStatsBuilder
implements Builder<MeterBandStats> {
    private BigInteger _byteBandCount;
    private BigInteger _packetBandCount;
    Map<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTEBANDCOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETBANDCOUNTRANGE_RANGES;

    public MeterBandStatsBuilder() {
    }

    public MeterBandStatsBuilder(MeterBandStats base) {
        AugmentationHolder casted;
        this._byteBandCount = base.getByteBandCount();
        this._packetBandCount = base.getPacketBandCount();
        if (base instanceof MeterBandStatsImpl) {
            MeterBandStatsImpl impl = (MeterBandStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>(casted.augmentations());
        }
    }

    public BigInteger getByteBandCount() {
        return this._byteBandCount;
    }

    public BigInteger getPacketBandCount() {
        return this._packetBandCount;
    }

    public <E extends Augmentation<MeterBandStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteBandCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTEBANDCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTEBANDCOUNTRANGE_RANGES)));
    }

    public MeterBandStatsBuilder setByteBandCount(BigInteger value) {
        if (value != null) {
            MeterBandStatsBuilder.checkByteBandCountRange(value);
        }
        this._byteBandCount = value;
        return this;
    }

    private static void checkPacketBandCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETBANDCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETBANDCOUNTRANGE_RANGES)));
    }

    public MeterBandStatsBuilder setPacketBandCount(BigInteger value) {
        if (value != null) {
            MeterBandStatsBuilder.checkPacketBandCountRange(value);
        }
        this._packetBandCount = value;
        return this;
    }

    public MeterBandStatsBuilder addAugmentation(Class<? extends Augmentation<MeterBandStats>> augmentationType, Augmentation<MeterBandStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBandStatsBuilder removeAugmentation(Class<? extends Augmentation<MeterBandStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MeterBandStats build() {
        return new MeterBandStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTEBANDCOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETBANDCOUNTRANGE_RANGES = a;
    }

    private static final class MeterBandStatsImpl
    implements MeterBandStats {
        private final BigInteger _byteBandCount;
        private final BigInteger _packetBandCount;
        private Map<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MeterBandStats> getImplementedInterface() {
            return MeterBandStats.class;
        }

        private MeterBandStatsImpl(MeterBandStatsBuilder base) {
            this._byteBandCount = base.getByteBandCount();
            this._packetBandCount = base.getPacketBandCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getByteBandCount() {
            return this._byteBandCount;
        }

        @Override
        public BigInteger getPacketBandCount() {
            return this._packetBandCount;
        }

        public <E extends Augmentation<MeterBandStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteBandCount);
            result = 31 * result + Objects.hashCode(this._packetBandCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MeterBandStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MeterBandStats other = (MeterBandStats)obj;
            if (!Objects.equals(this._byteBandCount, other.getByteBandCount())) {
                return false;
            }
            if (!Objects.equals(this._packetBandCount, other.getPacketBandCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterBandStatsImpl otherImpl = (MeterBandStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MeterBandStats [");
            boolean first = true;
            if (this._byteBandCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_byteBandCount=");
                builder.append(this._byteBandCount);
            }
            if (this._packetBandCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_packetBandCount=");
                builder.append(this._packetBandCount);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

