/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterConfigBuilder
implements Builder<MeterConfig> {
    private List<Bands> _bands;
    private MeterFlags _flags;
    private MeterId _meterId;
    Map<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> augmentation = Collections.emptyMap();

    public MeterConfigBuilder() {
    }

    public MeterConfigBuilder(MeterConfig base) {
        AugmentationHolder casted;
        this._bands = base.getBands();
        this._flags = base.getFlags();
        this._meterId = base.getMeterId();
        if (base instanceof MeterConfigImpl) {
            MeterConfigImpl impl = (MeterConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>(casted.augmentations());
        }
    }

    public List<Bands> getBands() {
        return this._bands;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public <E extends Augmentation<MeterConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterConfigBuilder setBands(List<Bands> value) {
        this._bands = value;
        return this;
    }

    public MeterConfigBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterConfigBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterConfigBuilder addAugmentation(Class<? extends Augmentation<MeterConfig>> augmentationType, Augmentation<MeterConfig> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterConfigBuilder removeAugmentation(Class<? extends Augmentation<MeterConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MeterConfig build() {
        return new MeterConfigImpl(this);
    }

    private static final class MeterConfigImpl
    implements MeterConfig {
        private final List<Bands> _bands;
        private final MeterFlags _flags;
        private final MeterId _meterId;
        private Map<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MeterConfig> getImplementedInterface() {
            return MeterConfig.class;
        }

        private MeterConfigImpl(MeterConfigBuilder base) {
            this._bands = base.getBands();
            this._flags = base.getFlags();
            this._meterId = base.getMeterId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Bands> getBands() {
            return this._bands;
        }

        @Override
        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        public <E extends Augmentation<MeterConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bands);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._meterId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MeterConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MeterConfig other = (MeterConfig)obj;
            if (!Objects.equals(this._bands, other.getBands())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterConfigImpl otherImpl = (MeterConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MeterConfig [");
            boolean first = true;
            if (this._bands != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bands=");
                builder.append(this._bands);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

