/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartReplyMeterFeaturesBuilder
implements Builder<MultipartReplyMeterFeatures> {
    private MeterBandTypeBitmap _bandTypes;
    private MeterFlags _capabilities;
    private Short _maxBands;
    private Short _maxColor;
    private Long _maxMeter;
    Map<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> augmentation = Collections.emptyMap();

    public MultipartReplyMeterFeaturesBuilder() {
    }

    public MultipartReplyMeterFeaturesBuilder(MultipartReplyMeterFeatures base) {
        AugmentationHolder casted;
        this._bandTypes = base.getBandTypes();
        this._capabilities = base.getCapabilities();
        this._maxBands = base.getMaxBands();
        this._maxColor = base.getMaxColor();
        this._maxMeter = base.getMaxMeter();
        if (base instanceof MultipartReplyMeterFeaturesImpl) {
            MultipartReplyMeterFeaturesImpl impl = (MultipartReplyMeterFeaturesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>(casted.augmentations());
        }
    }

    public MeterBandTypeBitmap getBandTypes() {
        return this._bandTypes;
    }

    public MeterFlags getCapabilities() {
        return this._capabilities;
    }

    public Short getMaxBands() {
        return this._maxBands;
    }

    public Short getMaxColor() {
        return this._maxColor;
    }

    public Long getMaxMeter() {
        return this._maxMeter;
    }

    public <E extends Augmentation<MultipartReplyMeterFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartReplyMeterFeaturesBuilder setBandTypes(MeterBandTypeBitmap value) {
        this._bandTypes = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder setCapabilities(MeterFlags value) {
        this._capabilities = value;
        return this;
    }

    private static void checkMaxBandsRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MultipartReplyMeterFeaturesBuilder setMaxBands(Short value) {
        if (value != null) {
            MultipartReplyMeterFeaturesBuilder.checkMaxBandsRange(value);
        }
        this._maxBands = value;
        return this;
    }

    private static void checkMaxColorRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MultipartReplyMeterFeaturesBuilder setMaxColor(Short value) {
        if (value != null) {
            MultipartReplyMeterFeaturesBuilder.checkMaxColorRange(value);
        }
        this._maxColor = value;
        return this;
    }

    private static void checkMaxMeterRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartReplyMeterFeaturesBuilder setMaxMeter(Long value) {
        if (value != null) {
            MultipartReplyMeterFeaturesBuilder.checkMaxMeterRange(value);
        }
        this._maxMeter = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder addAugmentation(Class<? extends Augmentation<MultipartReplyMeterFeatures>> augmentationType, Augmentation<MultipartReplyMeterFeatures> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder removeAugmentation(Class<? extends Augmentation<MultipartReplyMeterFeatures>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartReplyMeterFeatures build() {
        return new MultipartReplyMeterFeaturesImpl(this);
    }

    private static final class MultipartReplyMeterFeaturesImpl
    implements MultipartReplyMeterFeatures {
        private final MeterBandTypeBitmap _bandTypes;
        private final MeterFlags _capabilities;
        private final Short _maxBands;
        private final Short _maxColor;
        private final Long _maxMeter;
        private Map<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartReplyMeterFeatures> getImplementedInterface() {
            return MultipartReplyMeterFeatures.class;
        }

        private MultipartReplyMeterFeaturesImpl(MultipartReplyMeterFeaturesBuilder base) {
            this._bandTypes = base.getBandTypes();
            this._capabilities = base.getCapabilities();
            this._maxBands = base.getMaxBands();
            this._maxColor = base.getMaxColor();
            this._maxMeter = base.getMaxMeter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>(base.augmentation);
                }
            }
        }

        @Override
        public MeterBandTypeBitmap getBandTypes() {
            return this._bandTypes;
        }

        @Override
        public MeterFlags getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Short getMaxBands() {
            return this._maxBands;
        }

        @Override
        public Short getMaxColor() {
            return this._maxColor;
        }

        @Override
        public Long getMaxMeter() {
            return this._maxMeter;
        }

        public <E extends Augmentation<MultipartReplyMeterFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandTypes);
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._maxBands);
            result = 31 * result + Objects.hashCode(this._maxColor);
            result = 31 * result + Objects.hashCode(this._maxMeter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartReplyMeterFeatures.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartReplyMeterFeatures other = (MultipartReplyMeterFeatures)obj;
            if (!Objects.equals(this._bandTypes, other.getBandTypes())) {
                return false;
            }
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._maxBands, other.getMaxBands())) {
                return false;
            }
            if (!Objects.equals(this._maxColor, other.getMaxColor())) {
                return false;
            }
            if (!Objects.equals(this._maxMeter, other.getMaxMeter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartReplyMeterFeaturesImpl otherImpl = (MultipartReplyMeterFeaturesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartReplyMeterFeatures [");
            boolean first = true;
            if (this._bandTypes != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandTypes=");
                builder.append(this._bandTypes);
            }
            if (this._capabilities != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_capabilities=");
                builder.append(this._capabilities);
            }
            if (this._maxBands != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxBands=");
                builder.append(this._maxBands);
            }
            if (this._maxColor != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxColor=");
                builder.append(this._maxColor);
            }
            if (this._maxMeter != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxMeter=");
                builder.append(this._maxMeter);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

