/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortStatsBuilder
implements Builder<PortStats> {
    private BigInteger _collisions;
    private Long _durationNsec;
    private Long _durationSec;
    private Long _portNo;
    private BigInteger _rxBytes;
    private BigInteger _rxCrcErr;
    private BigInteger _rxDropped;
    private BigInteger _rxErrors;
    private BigInteger _rxFrameErr;
    private BigInteger _rxOverErr;
    private BigInteger _rxPackets;
    private BigInteger _txBytes;
    private BigInteger _txDropped;
    private BigInteger _txErrors;
    private BigInteger _txPackets;
    Map<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOLLISIONSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXBYTESRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXCRCERRRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXDROPPEDRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXERRORSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXFRAMEERRRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXOVERERRRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRXPACKETSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXBYTESRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXDROPPEDRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXERRORSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXPACKETSRANGE_RANGES;

    public PortStatsBuilder() {
    }

    public PortStatsBuilder(PortStats base) {
        AugmentationHolder casted;
        this._collisions = base.getCollisions();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._portNo = base.getPortNo();
        this._rxBytes = base.getRxBytes();
        this._rxCrcErr = base.getRxCrcErr();
        this._rxDropped = base.getRxDropped();
        this._rxErrors = base.getRxErrors();
        this._rxFrameErr = base.getRxFrameErr();
        this._rxOverErr = base.getRxOverErr();
        this._rxPackets = base.getRxPackets();
        this._txBytes = base.getTxBytes();
        this._txDropped = base.getTxDropped();
        this._txErrors = base.getTxErrors();
        this._txPackets = base.getTxPackets();
        if (base instanceof PortStatsImpl) {
            PortStatsImpl impl = (PortStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>(casted.augmentations());
        }
    }

    public BigInteger getCollisions() {
        return this._collisions;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public BigInteger getRxBytes() {
        return this._rxBytes;
    }

    public BigInteger getRxCrcErr() {
        return this._rxCrcErr;
    }

    public BigInteger getRxDropped() {
        return this._rxDropped;
    }

    public BigInteger getRxErrors() {
        return this._rxErrors;
    }

    public BigInteger getRxFrameErr() {
        return this._rxFrameErr;
    }

    public BigInteger getRxOverErr() {
        return this._rxOverErr;
    }

    public BigInteger getRxPackets() {
        return this._rxPackets;
    }

    public BigInteger getTxBytes() {
        return this._txBytes;
    }

    public BigInteger getTxDropped() {
        return this._txDropped;
    }

    public BigInteger getTxErrors() {
        return this._txErrors;
    }

    public BigInteger getTxPackets() {
        return this._txPackets;
    }

    public <E extends Augmentation<PortStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCollisionsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOLLISIONSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOLLISIONSRANGE_RANGES)));
    }

    public PortStatsBuilder setCollisions(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkCollisionsRange(value);
        }
        this._collisions = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            PortStatsBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            PortStatsBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortStatsBuilder setPortNo(Long value) {
        if (value != null) {
            PortStatsBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    private static void checkRxBytesRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXBYTESRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXBYTESRANGE_RANGES)));
    }

    public PortStatsBuilder setRxBytes(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxBytesRange(value);
        }
        this._rxBytes = value;
        return this;
    }

    private static void checkRxCrcErrRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXCRCERRRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXCRCERRRANGE_RANGES)));
    }

    public PortStatsBuilder setRxCrcErr(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxCrcErrRange(value);
        }
        this._rxCrcErr = value;
        return this;
    }

    private static void checkRxDroppedRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXDROPPEDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXDROPPEDRANGE_RANGES)));
    }

    public PortStatsBuilder setRxDropped(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxDroppedRange(value);
        }
        this._rxDropped = value;
        return this;
    }

    private static void checkRxErrorsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXERRORSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXERRORSRANGE_RANGES)));
    }

    public PortStatsBuilder setRxErrors(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxErrorsRange(value);
        }
        this._rxErrors = value;
        return this;
    }

    private static void checkRxFrameErrRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXFRAMEERRRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXFRAMEERRRANGE_RANGES)));
    }

    public PortStatsBuilder setRxFrameErr(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxFrameErrRange(value);
        }
        this._rxFrameErr = value;
        return this;
    }

    private static void checkRxOverErrRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXOVERERRRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXOVERERRRANGE_RANGES)));
    }

    public PortStatsBuilder setRxOverErr(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxOverErrRange(value);
        }
        this._rxOverErr = value;
        return this;
    }

    private static void checkRxPacketsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRXPACKETSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRXPACKETSRANGE_RANGES)));
    }

    public PortStatsBuilder setRxPackets(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkRxPacketsRange(value);
        }
        this._rxPackets = value;
        return this;
    }

    private static void checkTxBytesRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXBYTESRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXBYTESRANGE_RANGES)));
    }

    public PortStatsBuilder setTxBytes(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkTxBytesRange(value);
        }
        this._txBytes = value;
        return this;
    }

    private static void checkTxDroppedRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXDROPPEDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXDROPPEDRANGE_RANGES)));
    }

    public PortStatsBuilder setTxDropped(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkTxDroppedRange(value);
        }
        this._txDropped = value;
        return this;
    }

    private static void checkTxErrorsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXERRORSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXERRORSRANGE_RANGES)));
    }

    public PortStatsBuilder setTxErrors(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkTxErrorsRange(value);
        }
        this._txErrors = value;
        return this;
    }

    private static void checkTxPacketsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXPACKETSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXPACKETSRANGE_RANGES)));
    }

    public PortStatsBuilder setTxPackets(BigInteger value) {
        if (value != null) {
            PortStatsBuilder.checkTxPacketsRange(value);
        }
        this._txPackets = value;
        return this;
    }

    public PortStatsBuilder addAugmentation(Class<? extends Augmentation<PortStats>> augmentationType, Augmentation<PortStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortStatsBuilder removeAugmentation(Class<? extends Augmentation<PortStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortStats build() {
        return new PortStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOLLISIONSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXBYTESRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXCRCERRRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXDROPPEDRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXERRORSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXFRAMEERRRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXOVERERRRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRXPACKETSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXBYTESRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXDROPPEDRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXERRORSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXPACKETSRANGE_RANGES = a;
    }

    private static final class PortStatsImpl
    implements PortStats {
        private final BigInteger _collisions;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _portNo;
        private final BigInteger _rxBytes;
        private final BigInteger _rxCrcErr;
        private final BigInteger _rxDropped;
        private final BigInteger _rxErrors;
        private final BigInteger _rxFrameErr;
        private final BigInteger _rxOverErr;
        private final BigInteger _rxPackets;
        private final BigInteger _txBytes;
        private final BigInteger _txDropped;
        private final BigInteger _txErrors;
        private final BigInteger _txPackets;
        private Map<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortStats> getImplementedInterface() {
            return PortStats.class;
        }

        private PortStatsImpl(PortStatsBuilder base) {
            this._collisions = base.getCollisions();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._portNo = base.getPortNo();
            this._rxBytes = base.getRxBytes();
            this._rxCrcErr = base.getRxCrcErr();
            this._rxDropped = base.getRxDropped();
            this._rxErrors = base.getRxErrors();
            this._rxFrameErr = base.getRxFrameErr();
            this._rxOverErr = base.getRxOverErr();
            this._rxPackets = base.getRxPackets();
            this._txBytes = base.getTxBytes();
            this._txDropped = base.getTxDropped();
            this._txErrors = base.getTxErrors();
            this._txPackets = base.getTxPackets();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getCollisions() {
            return this._collisions;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public BigInteger getRxBytes() {
            return this._rxBytes;
        }

        @Override
        public BigInteger getRxCrcErr() {
            return this._rxCrcErr;
        }

        @Override
        public BigInteger getRxDropped() {
            return this._rxDropped;
        }

        @Override
        public BigInteger getRxErrors() {
            return this._rxErrors;
        }

        @Override
        public BigInteger getRxFrameErr() {
            return this._rxFrameErr;
        }

        @Override
        public BigInteger getRxOverErr() {
            return this._rxOverErr;
        }

        @Override
        public BigInteger getRxPackets() {
            return this._rxPackets;
        }

        @Override
        public BigInteger getTxBytes() {
            return this._txBytes;
        }

        @Override
        public BigInteger getTxDropped() {
            return this._txDropped;
        }

        @Override
        public BigInteger getTxErrors() {
            return this._txErrors;
        }

        @Override
        public BigInteger getTxPackets() {
            return this._txPackets;
        }

        public <E extends Augmentation<PortStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._collisions);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode(this._rxBytes);
            result = 31 * result + Objects.hashCode(this._rxCrcErr);
            result = 31 * result + Objects.hashCode(this._rxDropped);
            result = 31 * result + Objects.hashCode(this._rxErrors);
            result = 31 * result + Objects.hashCode(this._rxFrameErr);
            result = 31 * result + Objects.hashCode(this._rxOverErr);
            result = 31 * result + Objects.hashCode(this._rxPackets);
            result = 31 * result + Objects.hashCode(this._txBytes);
            result = 31 * result + Objects.hashCode(this._txDropped);
            result = 31 * result + Objects.hashCode(this._txErrors);
            result = 31 * result + Objects.hashCode(this._txPackets);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortStats other = (PortStats)obj;
            if (!Objects.equals(this._collisions, other.getCollisions())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals(this._rxBytes, other.getRxBytes())) {
                return false;
            }
            if (!Objects.equals(this._rxCrcErr, other.getRxCrcErr())) {
                return false;
            }
            if (!Objects.equals(this._rxDropped, other.getRxDropped())) {
                return false;
            }
            if (!Objects.equals(this._rxErrors, other.getRxErrors())) {
                return false;
            }
            if (!Objects.equals(this._rxFrameErr, other.getRxFrameErr())) {
                return false;
            }
            if (!Objects.equals(this._rxOverErr, other.getRxOverErr())) {
                return false;
            }
            if (!Objects.equals(this._rxPackets, other.getRxPackets())) {
                return false;
            }
            if (!Objects.equals(this._txBytes, other.getTxBytes())) {
                return false;
            }
            if (!Objects.equals(this._txDropped, other.getTxDropped())) {
                return false;
            }
            if (!Objects.equals(this._txErrors, other.getTxErrors())) {
                return false;
            }
            if (!Objects.equals(this._txPackets, other.getTxPackets())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortStatsImpl otherImpl = (PortStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PortStats [");
            boolean first = true;
            if (this._collisions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_collisions=");
                builder.append(this._collisions);
            }
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (this._rxBytes != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxBytes=");
                builder.append(this._rxBytes);
            }
            if (this._rxCrcErr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxCrcErr=");
                builder.append(this._rxCrcErr);
            }
            if (this._rxDropped != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxDropped=");
                builder.append(this._rxDropped);
            }
            if (this._rxErrors != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxErrors=");
                builder.append(this._rxErrors);
            }
            if (this._rxFrameErr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxFrameErr=");
                builder.append(this._rxFrameErr);
            }
            if (this._rxOverErr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxOverErr=");
                builder.append(this._rxOverErr);
            }
            if (this._rxPackets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rxPackets=");
                builder.append(this._rxPackets);
            }
            if (this._txBytes != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txBytes=");
                builder.append(this._txBytes);
            }
            if (this._txDropped != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txDropped=");
                builder.append(this._txDropped);
            }
            if (this._txErrors != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txErrors=");
                builder.append(this._txErrors);
            }
            if (this._txPackets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txPackets=");
                builder.append(this._txPackets);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

