/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueueStatsBuilder
implements Builder<QueueStats> {
    private Long _durationNsec;
    private Long _durationSec;
    private Long _portNo;
    private Long _queueId;
    private BigInteger _txBytes;
    private BigInteger _txErrors;
    private BigInteger _txPackets;
    Map<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTXBYTESRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXERRORSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTXPACKETSRANGE_RANGES;

    public QueueStatsBuilder() {
    }

    public QueueStatsBuilder(QueueStats base) {
        AugmentationHolder casted;
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._portNo = base.getPortNo();
        this._queueId = base.getQueueId();
        this._txBytes = base.getTxBytes();
        this._txErrors = base.getTxErrors();
        this._txPackets = base.getTxPackets();
        if (base instanceof QueueStatsImpl) {
            QueueStatsImpl impl = (QueueStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>(casted.augmentations());
        }
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public Long getQueueId() {
        return this._queueId;
    }

    public BigInteger getTxBytes() {
        return this._txBytes;
    }

    public BigInteger getTxErrors() {
        return this._txErrors;
    }

    public BigInteger getTxPackets() {
        return this._txPackets;
    }

    public <E extends Augmentation<QueueStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public QueueStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            QueueStatsBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public QueueStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            QueueStatsBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public QueueStatsBuilder setPortNo(Long value) {
        if (value != null) {
            QueueStatsBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    private static void checkQueueIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public QueueStatsBuilder setQueueId(Long value) {
        if (value != null) {
            QueueStatsBuilder.checkQueueIdRange(value);
        }
        this._queueId = value;
        return this;
    }

    private static void checkTxBytesRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXBYTESRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXBYTESRANGE_RANGES)));
    }

    public QueueStatsBuilder setTxBytes(BigInteger value) {
        if (value != null) {
            QueueStatsBuilder.checkTxBytesRange(value);
        }
        this._txBytes = value;
        return this;
    }

    private static void checkTxErrorsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXERRORSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXERRORSRANGE_RANGES)));
    }

    public QueueStatsBuilder setTxErrors(BigInteger value) {
        if (value != null) {
            QueueStatsBuilder.checkTxErrorsRange(value);
        }
        this._txErrors = value;
        return this;
    }

    private static void checkTxPacketsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTXPACKETSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTXPACKETSRANGE_RANGES)));
    }

    public QueueStatsBuilder setTxPackets(BigInteger value) {
        if (value != null) {
            QueueStatsBuilder.checkTxPacketsRange(value);
        }
        this._txPackets = value;
        return this;
    }

    public QueueStatsBuilder addAugmentation(Class<? extends Augmentation<QueueStats>> augmentationType, Augmentation<QueueStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueueStatsBuilder removeAugmentation(Class<? extends Augmentation<QueueStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QueueStats build() {
        return new QueueStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXBYTESRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXERRORSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTXPACKETSRANGE_RANGES = a;
    }

    private static final class QueueStatsImpl
    implements QueueStats {
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _portNo;
        private final Long _queueId;
        private final BigInteger _txBytes;
        private final BigInteger _txErrors;
        private final BigInteger _txPackets;
        private Map<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<QueueStats> getImplementedInterface() {
            return QueueStats.class;
        }

        private QueueStatsImpl(QueueStatsBuilder base) {
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._portNo = base.getPortNo();
            this._queueId = base.getQueueId();
            this._txBytes = base.getTxBytes();
            this._txErrors = base.getTxErrors();
            this._txPackets = base.getTxPackets();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        @Override
        public BigInteger getTxBytes() {
            return this._txBytes;
        }

        @Override
        public BigInteger getTxErrors() {
            return this._txErrors;
        }

        @Override
        public BigInteger getTxPackets() {
            return this._txPackets;
        }

        public <E extends Augmentation<QueueStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode(this._queueId);
            result = 31 * result + Objects.hashCode(this._txBytes);
            result = 31 * result + Objects.hashCode(this._txErrors);
            result = 31 * result + Objects.hashCode(this._txPackets);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QueueStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            QueueStats other = (QueueStats)obj;
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (!Objects.equals(this._txBytes, other.getTxBytes())) {
                return false;
            }
            if (!Objects.equals(this._txErrors, other.getTxErrors())) {
                return false;
            }
            if (!Objects.equals(this._txPackets, other.getTxPackets())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QueueStatsImpl otherImpl = (QueueStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("QueueStats [");
            boolean first = true;
            if (this._durationNsec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
            }
            if (this._durationSec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_durationSec=");
                builder.append(this._durationSec);
            }
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (this._queueId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            if (this._txBytes != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txBytes=");
                builder.append(this._txBytes);
            }
            if (this._txErrors != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txErrors=");
                builder.append(this._txErrors);
            }
            if (this._txPackets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_txPackets=");
                builder.append(this._txPackets);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

