/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableStatsBuilder
implements Builder<TableStats> {
    private Long _activeCount;
    private BigInteger _lookupCount;
    private BigInteger _matchedCount;
    private Long _maxEntries;
    private String _name;
    private Short _nwDstMask;
    private Short _nwSrcMask;
    private Short _tableId;
    private FlowWildcardsV10 _wildcards;
    Map<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKLOOKUPCOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKMATCHEDCOUNTRANGE_RANGES;

    public TableStatsBuilder() {
    }

    public TableStatsBuilder(TableStats base) {
        AugmentationHolder casted;
        this._activeCount = base.getActiveCount();
        this._lookupCount = base.getLookupCount();
        this._matchedCount = base.getMatchedCount();
        this._maxEntries = base.getMaxEntries();
        this._name = base.getName();
        this._nwDstMask = base.getNwDstMask();
        this._nwSrcMask = base.getNwSrcMask();
        this._tableId = base.getTableId();
        this._wildcards = base.getWildcards();
        if (base instanceof TableStatsImpl) {
            TableStatsImpl impl = (TableStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>(casted.augmentations());
        }
    }

    public Long getActiveCount() {
        return this._activeCount;
    }

    public BigInteger getLookupCount() {
        return this._lookupCount;
    }

    public BigInteger getMatchedCount() {
        return this._matchedCount;
    }

    public Long getMaxEntries() {
        return this._maxEntries;
    }

    public String getName() {
        return this._name;
    }

    public Short getNwDstMask() {
        return this._nwDstMask;
    }

    public Short getNwSrcMask() {
        return this._nwSrcMask;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public FlowWildcardsV10 getWildcards() {
        return this._wildcards;
    }

    public <E extends Augmentation<TableStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkActiveCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TableStatsBuilder setActiveCount(Long value) {
        if (value != null) {
            TableStatsBuilder.checkActiveCountRange(value);
        }
        this._activeCount = value;
        return this;
    }

    private static void checkLookupCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLOOKUPCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKLOOKUPCOUNTRANGE_RANGES)));
    }

    public TableStatsBuilder setLookupCount(BigInteger value) {
        if (value != null) {
            TableStatsBuilder.checkLookupCountRange(value);
        }
        this._lookupCount = value;
        return this;
    }

    private static void checkMatchedCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKMATCHEDCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKMATCHEDCOUNTRANGE_RANGES)));
    }

    public TableStatsBuilder setMatchedCount(BigInteger value) {
        if (value != null) {
            TableStatsBuilder.checkMatchedCountRange(value);
        }
        this._matchedCount = value;
        return this;
    }

    private static void checkMaxEntriesRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TableStatsBuilder setMaxEntries(Long value) {
        if (value != null) {
            TableStatsBuilder.checkMaxEntriesRange(value);
        }
        this._maxEntries = value;
        return this;
    }

    public TableStatsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkNwDstMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableStatsBuilder setNwDstMask(Short value) {
        if (value != null) {
            TableStatsBuilder.checkNwDstMaskRange(value);
        }
        this._nwDstMask = value;
        return this;
    }

    private static void checkNwSrcMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableStatsBuilder setNwSrcMask(Short value) {
        if (value != null) {
            TableStatsBuilder.checkNwSrcMaskRange(value);
        }
        this._nwSrcMask = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableStatsBuilder setTableId(Short value) {
        if (value != null) {
            TableStatsBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public TableStatsBuilder setWildcards(FlowWildcardsV10 value) {
        this._wildcards = value;
        return this;
    }

    public TableStatsBuilder addAugmentation(Class<? extends Augmentation<TableStats>> augmentationType, Augmentation<TableStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableStatsBuilder removeAugmentation(Class<? extends Augmentation<TableStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableStats build() {
        return new TableStatsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKLOOKUPCOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKMATCHEDCOUNTRANGE_RANGES = a;
    }

    private static final class TableStatsImpl
    implements TableStats {
        private final Long _activeCount;
        private final BigInteger _lookupCount;
        private final BigInteger _matchedCount;
        private final Long _maxEntries;
        private final String _name;
        private final Short _nwDstMask;
        private final Short _nwSrcMask;
        private final Short _tableId;
        private final FlowWildcardsV10 _wildcards;
        private Map<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableStats> getImplementedInterface() {
            return TableStats.class;
        }

        private TableStatsImpl(TableStatsBuilder base) {
            this._activeCount = base.getActiveCount();
            this._lookupCount = base.getLookupCount();
            this._matchedCount = base.getMatchedCount();
            this._maxEntries = base.getMaxEntries();
            this._name = base.getName();
            this._nwDstMask = base.getNwDstMask();
            this._nwSrcMask = base.getNwSrcMask();
            this._tableId = base.getTableId();
            this._wildcards = base.getWildcards();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getActiveCount() {
            return this._activeCount;
        }

        @Override
        public BigInteger getLookupCount() {
            return this._lookupCount;
        }

        @Override
        public BigInteger getMatchedCount() {
            return this._matchedCount;
        }

        @Override
        public Long getMaxEntries() {
            return this._maxEntries;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Short getNwDstMask() {
            return this._nwDstMask;
        }

        @Override
        public Short getNwSrcMask() {
            return this._nwSrcMask;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        @Override
        public FlowWildcardsV10 getWildcards() {
            return this._wildcards;
        }

        public <E extends Augmentation<TableStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._activeCount);
            result = 31 * result + Objects.hashCode(this._lookupCount);
            result = 31 * result + Objects.hashCode(this._matchedCount);
            result = 31 * result + Objects.hashCode(this._maxEntries);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._nwDstMask);
            result = 31 * result + Objects.hashCode(this._nwSrcMask);
            result = 31 * result + Objects.hashCode(this._tableId);
            result = 31 * result + Objects.hashCode(this._wildcards);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableStats other = (TableStats)obj;
            if (!Objects.equals(this._activeCount, other.getActiveCount())) {
                return false;
            }
            if (!Objects.equals(this._lookupCount, other.getLookupCount())) {
                return false;
            }
            if (!Objects.equals(this._matchedCount, other.getMatchedCount())) {
                return false;
            }
            if (!Objects.equals(this._maxEntries, other.getMaxEntries())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._nwDstMask, other.getNwDstMask())) {
                return false;
            }
            if (!Objects.equals(this._nwSrcMask, other.getNwSrcMask())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (!Objects.equals(this._wildcards, other.getWildcards())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableStatsImpl otherImpl = (TableStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TableStats [");
            boolean first = true;
            if (this._activeCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_activeCount=");
                builder.append(this._activeCount);
            }
            if (this._lookupCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lookupCount=");
                builder.append(this._lookupCount);
            }
            if (this._matchedCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchedCount=");
                builder.append(this._matchedCount);
            }
            if (this._maxEntries != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxEntries=");
                builder.append(this._maxEntries);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._nwDstMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwDstMask=");
                builder.append(this._nwDstMask);
            }
            if (this._nwSrcMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nwSrcMask=");
                builder.append(this._nwSrcMask);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (this._wildcards != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_wildcards=");
                builder.append(this._wildcards);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

