/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterCore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenter;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestExperimenterBuilder
implements Builder<MultipartRequestExperimenter> {
    private Long _expType;
    private ExperimenterId _experimenter;
    private ExperimenterDataOfChoice _experimenterDataOfChoice;
    Map<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>> augmentation = Collections.emptyMap();

    public MultipartRequestExperimenterBuilder() {
    }

    public MultipartRequestExperimenterBuilder(ExperimenterCore arg) {
        this._experimenter = arg.getExperimenter();
        this._expType = arg.getExpType();
        this._experimenterDataOfChoice = arg.getExperimenterDataOfChoice();
    }

    public MultipartRequestExperimenterBuilder(MultipartRequestExperimenter base) {
        AugmentationHolder casted;
        this._expType = base.getExpType();
        this._experimenter = base.getExperimenter();
        this._experimenterDataOfChoice = base.getExperimenterDataOfChoice();
        if (base instanceof MultipartRequestExperimenterImpl) {
            MultipartRequestExperimenterImpl impl = (MultipartRequestExperimenterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ExperimenterCore) {
            this._experimenter = ((ExperimenterCore)arg).getExperimenter();
            this._expType = ((ExperimenterCore)arg).getExpType();
            this._experimenterDataOfChoice = ((ExperimenterCore)arg).getExperimenterDataOfChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterCore] \nbut was: " + arg);
        }
    }

    public Long getExpType() {
        return this._expType;
    }

    public ExperimenterId getExperimenter() {
        return this._experimenter;
    }

    public ExperimenterDataOfChoice getExperimenterDataOfChoice() {
        return this._experimenterDataOfChoice;
    }

    public <E extends Augmentation<MultipartRequestExperimenter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkExpTypeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestExperimenterBuilder setExpType(Long value) {
        if (value != null) {
            MultipartRequestExperimenterBuilder.checkExpTypeRange(value);
        }
        this._expType = value;
        return this;
    }

    public MultipartRequestExperimenterBuilder setExperimenter(ExperimenterId value) {
        this._experimenter = value;
        return this;
    }

    public MultipartRequestExperimenterBuilder setExperimenterDataOfChoice(ExperimenterDataOfChoice value) {
        this._experimenterDataOfChoice = value;
        return this;
    }

    public MultipartRequestExperimenterBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestExperimenter>> augmentationType, Augmentation<MultipartRequestExperimenter> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestExperimenterBuilder removeAugmentation(Class<? extends Augmentation<MultipartRequestExperimenter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartRequestExperimenter build() {
        return new MultipartRequestExperimenterImpl(this);
    }

    private static final class MultipartRequestExperimenterImpl
    implements MultipartRequestExperimenter {
        private final Long _expType;
        private final ExperimenterId _experimenter;
        private final ExperimenterDataOfChoice _experimenterDataOfChoice;
        private Map<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartRequestExperimenter> getImplementedInterface() {
            return MultipartRequestExperimenter.class;
        }

        private MultipartRequestExperimenterImpl(MultipartRequestExperimenterBuilder base) {
            this._expType = base.getExpType();
            this._experimenter = base.getExperimenter();
            this._experimenterDataOfChoice = base.getExperimenterDataOfChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getExpType() {
            return this._expType;
        }

        @Override
        public ExperimenterId getExperimenter() {
            return this._experimenter;
        }

        @Override
        public ExperimenterDataOfChoice getExperimenterDataOfChoice() {
            return this._experimenterDataOfChoice;
        }

        public <E extends Augmentation<MultipartRequestExperimenter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._expType);
            result = 31 * result + Objects.hashCode(this._experimenter);
            result = 31 * result + Objects.hashCode(this._experimenterDataOfChoice);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartRequestExperimenter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartRequestExperimenter other = (MultipartRequestExperimenter)obj;
            if (!Objects.equals(this._expType, other.getExpType())) {
                return false;
            }
            if (!Objects.equals(this._experimenter, other.getExperimenter())) {
                return false;
            }
            if (!Objects.equals(this._experimenterDataOfChoice, other.getExperimenterDataOfChoice())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartRequestExperimenterImpl otherImpl = (MultipartRequestExperimenterImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartRequestExperimenter>>, Augmentation<MultipartRequestExperimenter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartRequestExperimenter [");
            boolean first = true;
            if (this._expType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_expType=");
                builder.append(this._expType);
            }
            if (this._experimenter != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenter=");
                builder.append(this._experimenter);
            }
            if (this._experimenterDataOfChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterDataOfChoice=");
                builder.append(this._experimenterDataOfChoice);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

