/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlow;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestFlowBuilder
implements Builder<MultipartRequestFlow> {
    private BigInteger _cookie;
    private BigInteger _cookieMask;
    private Match _match;
    private MatchV10 _matchV10;
    private Long _outGroup;
    private Long _outPort;
    private Short _tableId;
    Map<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKCOOKIEMASKRANGE_RANGES;

    public MultipartRequestFlowBuilder() {
    }

    public MultipartRequestFlowBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public MultipartRequestFlowBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public MultipartRequestFlowBuilder(MultipartRequestFlow base) {
        AugmentationHolder casted;
        this._cookie = base.getCookie();
        this._cookieMask = base.getCookieMask();
        this._match = base.getMatch();
        this._matchV10 = base.getMatchV10();
        this._outGroup = base.getOutGroup();
        this._outPort = base.getOutPort();
        this._tableId = base.getTableId();
        if (base instanceof MultipartRequestFlowImpl) {
            MultipartRequestFlowImpl impl = (MultipartRequestFlowImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchV10Grouping] \nbut was: " + arg);
        }
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public BigInteger getCookieMask() {
        return this._cookieMask;
    }

    public Match getMatch() {
        return this._match;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public Long getOutGroup() {
        return this._outGroup;
    }

    public Long getOutPort() {
        return this._outPort;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<MultipartRequestFlow>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public MultipartRequestFlowBuilder setCookie(BigInteger value) {
        if (value != null) {
            MultipartRequestFlowBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    private static void checkCookieMaskRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIEMASKRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIEMASKRANGE_RANGES)));
    }

    public MultipartRequestFlowBuilder setCookieMask(BigInteger value) {
        if (value != null) {
            MultipartRequestFlowBuilder.checkCookieMaskRange(value);
        }
        this._cookieMask = value;
        return this;
    }

    public MultipartRequestFlowBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public MultipartRequestFlowBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    private static void checkOutGroupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestFlowBuilder setOutGroup(Long value) {
        if (value != null) {
            MultipartRequestFlowBuilder.checkOutGroupRange(value);
        }
        this._outGroup = value;
        return this;
    }

    private static void checkOutPortRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestFlowBuilder setOutPort(Long value) {
        if (value != null) {
            MultipartRequestFlowBuilder.checkOutPortRange(value);
        }
        this._outPort = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public MultipartRequestFlowBuilder setTableId(Short value) {
        if (value != null) {
            MultipartRequestFlowBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public MultipartRequestFlowBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestFlow>> augmentationType, Augmentation<MultipartRequestFlow> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestFlowBuilder removeAugmentation(Class<? extends Augmentation<MultipartRequestFlow>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartRequestFlow build() {
        return new MultipartRequestFlowImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIEMASKRANGE_RANGES = a;
    }

    private static final class MultipartRequestFlowImpl
    implements MultipartRequestFlow {
        private final BigInteger _cookie;
        private final BigInteger _cookieMask;
        private final Match _match;
        private final MatchV10 _matchV10;
        private final Long _outGroup;
        private final Long _outPort;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartRequestFlow> getImplementedInterface() {
            return MultipartRequestFlow.class;
        }

        private MultipartRequestFlowImpl(MultipartRequestFlowBuilder base) {
            this._cookie = base.getCookie();
            this._cookieMask = base.getCookieMask();
            this._match = base.getMatch();
            this._matchV10 = base.getMatchV10();
            this._outGroup = base.getOutGroup();
            this._outPort = base.getOutPort();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public BigInteger getCookieMask() {
            return this._cookieMask;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public Long getOutGroup() {
            return this._outGroup;
        }

        @Override
        public Long getOutPort() {
            return this._outPort;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<MultipartRequestFlow>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._cookieMask);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._matchV10);
            result = 31 * result + Objects.hashCode(this._outGroup);
            result = 31 * result + Objects.hashCode(this._outPort);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartRequestFlow.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartRequestFlow other = (MultipartRequestFlow)obj;
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._cookieMask, other.getCookieMask())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._matchV10, other.getMatchV10())) {
                return false;
            }
            if (!Objects.equals(this._outGroup, other.getOutGroup())) {
                return false;
            }
            if (!Objects.equals(this._outPort, other.getOutPort())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartRequestFlowImpl otherImpl = (MultipartRequestFlowImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartRequestFlow>>, Augmentation<MultipartRequestFlow>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartRequestFlow [");
            boolean first = true;
            if (this._cookie != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookie=");
                builder.append(this._cookie);
            }
            if (this._cookieMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cookieMask=");
                builder.append(this._cookieMask);
            }
            if (this._match != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_match=");
                builder.append(this._match);
            }
            if (this._matchV10 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchV10=");
                builder.append(this._matchV10);
            }
            if (this._outGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outGroup=");
                builder.append(this._outGroup);
            }
            if (this._outPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outPort=");
                builder.append(this._outPort);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

